/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.covered.IndexCodec;
import org.apache.phoenix.hbase.index.covered.example.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumnIndexCodec;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumnIndexer;

public class CoveredColumnIndexSpecifierBuilder {
    private static final String INDEX_TO_TABLE_CONF_PREFX = "hbase.index.covered.";
    private static final String COUNT = ".count";
    private static final String INDEX_GROUPS_COUNT_KEY = "hbase.index.covered..groups.count";
    private static final String INDEX_GROUP_PREFIX = "hbase.index.covered.group.";
    private static final String INDEX_GROUP_COVERAGE_SUFFIX = ".columns";
    private static final String TABLE_SUFFIX = ".table";
    List<ColumnGroup> groups = new ArrayList<ColumnGroup>();
    private Map<String, String> specs = new HashMap<String, String>();

    public int addIndexGroup(ColumnGroup columns) {
        if (columns == null || columns.size() == 0) {
            throw new IllegalArgumentException("Must specify some columns to index!");
        }
        int size = this.groups.size();
        this.groups.add(columns);
        return size;
    }

    public void remove(int i) {
        this.groups.remove(i);
    }

    public ColumnGroup get(int i) {
        return this.groups.get(i);
    }

    public void reset() {
        this.groups.clear();
    }

    Map<String, String> convertToMap() {
        int total = this.groups.size();
        this.specs.put(INDEX_GROUPS_COUNT_KEY, Integer.toString(total));
        int i = 0;
        for (ColumnGroup group : this.groups) {
            this.addIndexGroupToSpecs(this.specs, group, i++);
        }
        return this.specs;
    }

    private void addIndexGroupToSpecs(Map<String, String> specs, ColumnGroup columns, int index) {
        String prefix = INDEX_GROUP_PREFIX + Integer.toString(index);
        specs.put(prefix + TABLE_SUFFIX, columns.getTable());
        String columnPrefix = prefix + INDEX_GROUP_COVERAGE_SUFFIX;
        String columnsSizeKey = columnPrefix + COUNT;
        specs.put(columnsSizeKey, Integer.toString(columns.size()));
        int i = 0;
        for (CoveredColumn column : columns) {
            String nextKey = columnPrefix + "." + Integer.toString(i);
            String nextValue = column.serialize();
            specs.put(nextKey, nextValue);
            ++i;
        }
    }

    public void build(HTableDescriptor desc) throws IOException {
        this.build(desc, CoveredColumnIndexCodec.class);
    }

    void build(HTableDescriptor desc, Class<? extends IndexCodec> clazz) throws IOException {
        Map<String, String> opts = this.convertToMap();
        opts.put("org.apache.hadoop.hbase.index.codec.class", clazz.getName());
        Indexer.enableIndexing(desc, CoveredColumnIndexer.class, opts, 0x3FFFFFFF);
    }

    static List<ColumnGroup> getColumns(Configuration conf) {
        int count = conf.getInt(INDEX_GROUPS_COUNT_KEY, 0);
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<ColumnGroup> columns = new ArrayList<ColumnGroup>(count);
        for (int i = 0; i < count; ++i) {
            String prefix = INDEX_GROUP_PREFIX + i;
            String table = conf.get(prefix + TABLE_SUFFIX);
            ColumnGroup group = new ColumnGroup(table);
            String columnPrefix = prefix + INDEX_GROUP_COVERAGE_SUFFIX;
            String columnsSizeKey = columnPrefix + COUNT;
            int columnCount = conf.getInt(columnsSizeKey, 0);
            for (int j = 0; j < columnCount; ++j) {
                String columnKey = columnPrefix + "." + j;
                CoveredColumn column = CoveredColumn.parse(conf.get(columnKey));
                group.add(column);
            }
            columns.add(group);
        }
        return columns;
    }

    public void addArbitraryConfigForTesting(String key, String value) {
        this.specs.put(key, value);
    }
}

