/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowKeyComparisonFilter
extends BooleanExpressionFilter {
    private static final Logger logger = LoggerFactory.getLogger(RowKeyComparisonFilter.class);
    private boolean evaluate = true;
    private boolean keepRow = false;
    private RowKeyTuple inputTuple = new RowKeyTuple();
    private byte[] essentialCF;

    public RowKeyComparisonFilter() {
    }

    public RowKeyComparisonFilter(Expression expression, byte[] essentialCF) {
        super(expression);
        this.essentialCF = essentialCF;
    }

    @Override
    public void reset() {
        this.keepRow = false;
        this.evaluate = true;
        super.reset();
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.evaluate) {
            this.inputTuple.setKey(v.getRowArray(), v.getRowOffset(), v.getRowLength());
            this.keepRow = Boolean.TRUE.equals(this.evaluate(this.inputTuple));
            if (logger.isTraceEnabled()) {
                logger.trace("RowKeyComparisonFilter: " + (this.keepRow ? "KEEP" : "FILTER") + " row " + this.inputTuple);
            }
            this.evaluate = false;
        }
        return this.keepRow ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.NEXT_ROW;
    }

    @Override
    public boolean filterRow() {
        return !this.keepRow;
    }

    @Override
    public boolean isFamilyEssential(byte[] name) {
        return this.essentialCF.length == 0 ? true : Bytes.compareTo(this.essentialCF, name) == 0;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.essentialCF = WritableUtils.readCompressedByteArray(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeCompressedByteArray(output, this.essentialCF);
    }

    public static RowKeyComparisonFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (RowKeyComparisonFilter)Writables.getWritable(pbBytes, new RowKeyComparisonFilter());
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    private final class RowKeyTuple
    extends BaseTuple {
        private byte[] buf;
        private int offset;
        private int length;

        private RowKeyTuple() {
        }

        public void setKey(byte[] buf, int offset, int length) {
            this.buf = buf;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void getKey(ImmutableBytesWritable ptr) {
            ptr.set(this.buf, this.offset, this.length);
        }

        @Override
        public KeyValue getValue(byte[] cf, byte[] cq) {
            return null;
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        public String toString() {
            return Bytes.toStringBinary(this.buf, this.offset, this.length);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public KeyValue getValue(int index) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
            return false;
        }
    }
}

