/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.util.regex.AbstractBasePattern;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.RegexpReplaceParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;

@FunctionParseNode.BuiltInFunction(name="REGEXP_REPLACE", nodeClass=RegexpReplaceParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}, defaultValue="null")})
public abstract class RegexpReplaceFunction
extends ScalarFunction {
    public static final String NAME = "REGEXP_REPLACE";
    private static final PVarchar TYPE = PVarchar.INSTANCE;
    private byte[] rStrBytes;
    private int rStrOffset;
    private int rStrLen;
    private AbstractBasePattern pattern;

    public RegexpReplaceFunction() {
    }

    public RegexpReplaceFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    protected abstract AbstractBasePattern compilePatternSpec(String var1);

    private void init() {
        String patternStr;
        ImmutableBytesWritable tmpPtr = new ImmutableBytesWritable();
        Expression e = this.getPatternStrExpression();
        if (e.isStateless() && e.getDeterminism() == Determinism.ALWAYS && e.evaluate(null, tmpPtr) && (patternStr = (String)TYPE.toObject(tmpPtr, e.getDataType(), e.getSortOrder())) != null) {
            this.pattern = this.compilePatternSpec(patternStr);
        }
        if ((e = this.getReplaceStrExpression()).isStateless() && e.getDeterminism() == Determinism.ALWAYS && e.evaluate(null, tmpPtr)) {
            TYPE.coerceBytes(tmpPtr, TYPE, e.getSortOrder(), SortOrder.ASC);
            this.rStrBytes = tmpPtr.get();
            this.rStrOffset = tmpPtr.getOffset();
            this.rStrLen = tmpPtr.getLength();
        } else {
            this.rStrBytes = null;
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression sourceStrExpression;
        AbstractBasePattern pattern = this.pattern;
        if (pattern == null) {
            Expression e = this.getPatternStrExpression();
            if (!e.evaluate(tuple, ptr)) {
                return false;
            }
            String patternStr = (String)TYPE.toObject(ptr, e.getDataType(), e.getSortOrder());
            if (patternStr == null) {
                return false;
            }
            pattern = this.compilePatternSpec(patternStr);
        }
        byte[] rStrBytes = this.rStrBytes;
        int rStrOffset = this.rStrOffset;
        int rStrLen = this.rStrLen;
        if (rStrBytes == null) {
            Expression replaceStrExpression = this.getReplaceStrExpression();
            if (!replaceStrExpression.evaluate(tuple, ptr)) {
                return false;
            }
            TYPE.coerceBytes(ptr, TYPE, replaceStrExpression.getSortOrder(), SortOrder.ASC);
            rStrBytes = ptr.get();
            rStrOffset = ptr.getOffset();
            rStrLen = ptr.getLength();
        }
        if (!(sourceStrExpression = this.getSourceStrExpression()).evaluate(tuple, ptr)) {
            return false;
        }
        TYPE.coerceBytes(ptr, TYPE, sourceStrExpression.getSortOrder(), SortOrder.ASC);
        pattern.replaceAll(ptr, rStrBytes, rStrOffset, rStrLen);
        return true;
    }

    private Expression getSourceStrExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getPatternStrExpression() {
        return (Expression)this.children.get(1);
    }

    private Expression getReplaceStrExpression() {
        return (Expression)this.children.get(2);
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

