/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

@FunctionParseNode.BuiltInFunction(name="RTRIM", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class RTrimFunction
extends ScalarFunction {
    public static final String NAME = "RTRIM";

    public RTrimFunction() {
    }

    public RTrimFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    private Expression getStringExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        SortOrder sortOrder;
        int length;
        int offset;
        if (!this.getStringExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        byte[] string = ptr.get();
        int i = StringUtil.getFirstNonBlankCharIdxFromEnd(string, offset = ptr.getOffset(), length = ptr.getLength(), sortOrder = this.getStringExpression().getSortOrder());
        if (i == offset - 1) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        ptr.set(string, offset, i - offset + 1);
        return true;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES_IF_LAST;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return 0;
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                byte[] lowerRange = KeyRange.UNBOUND;
                byte[] upperRange = KeyRange.UNBOUND;
                boolean lowerInclusive = true;
                PDataType type = this.getColumn().getDataType();
                switch (op) {
                    case EQUAL: {
                        lowerRange = ScalarFunction.evaluateExpression(rhs);
                        upperRange = ByteUtil.nextKey(ByteUtil.concat(lowerRange, new byte[][]{{32}}));
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        lowerInclusive = false;
                        upperRange = ByteUtil.nextKey(ByteUtil.concat(ScalarFunction.evaluateExpression(rhs), new byte[][]{{32}}));
                        break;
                    }
                    default: {
                        return childPart.getKeyRange(op, rhs);
                    }
                }
                Integer length = this.getColumn().getMaxLength();
                if (type.isFixedWidth() && length != null) {
                    if (lowerRange != KeyRange.UNBOUND) {
                        lowerRange = StringUtil.padChar(lowerRange, length);
                    }
                    if (upperRange != KeyRange.UNBOUND) {
                        upperRange = StringUtil.padChar(upperRange, length);
                    }
                }
                return KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, false);
            }

            @Override
            public List<Expression> getExtractNodes() {
                return Collections.emptyList();
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }
        };
    }

    @Override
    public Integer getMaxLength() {
        return this.getStringExpression().getMaxLength();
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

