/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CurrentDateTimeFunction;
import org.apache.phoenix.parse.CurrentTimeParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTime;

@FunctionParseNode.BuiltInFunction(name="CURRENT_TIME", nodeClass=CurrentTimeParseNode.class, args={})
public class CurrentTimeFunction
extends CurrentDateTimeFunction {
    public static final String NAME = "CURRENT_TIME";
    private final ImmutableBytesWritable currentDate = new ImmutableBytesWritable(new byte[PTime.INSTANCE.getByteSize().intValue()]);

    public CurrentTimeFunction() {
        this(System.currentTimeMillis());
    }

    public CurrentTimeFunction(long timeStamp) {
        this.getDataType().getCodec().encodeLong(timeStamp, this.currentDate);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ptr.set(this.currentDate.get(), 0, PTime.INSTANCE.getByteSize());
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PTime.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

