/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;

public abstract class MinAggregator
extends BaseAggregator {
    protected final ImmutableBytesWritable value = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);

    public MinAggregator(SortOrder sortOrder) {
        super(sortOrder);
    }

    @Override
    public void reset() {
        this.value.set(ByteUtil.EMPTY_BYTE_ARRAY);
        super.reset();
    }

    @Override
    public int getSize() {
        return super.getSize() + 48;
    }

    protected boolean keepFirst(ImmutableBytesWritable ibw1, ImmutableBytesWritable ibw2) {
        return 0 >= this.getDataType().compareTo(ibw1, this.sortOrder, ibw2, this.sortOrder, this.getDataType());
    }

    private boolean isNull() {
        return this.value.get() == ByteUtil.EMPTY_BYTE_ARRAY;
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.isNull()) {
            this.value.set(ptr.get(), ptr.getOffset(), ptr.getLength());
        } else if (!this.keepFirst(this.value, ptr)) {
            this.value.set(ptr.get(), ptr.getOffset(), ptr.getLength());
        }
    }

    public String toString() {
        return "MIN [value=" + Bytes.toStringBinary(this.value.get(), this.value.getOffset(), this.value.getLength()) + "]";
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.isNull()) {
            return false;
        }
        ptr.set(this.value.get(), this.value.getOffset(), this.value.getLength());
        return true;
    }
}

