/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;

public class OrderByExpression
implements Writable {
    private Expression expression;
    private boolean isNullsLast;
    private boolean isAscending;

    public OrderByExpression() {
    }

    public OrderByExpression(Expression expression, boolean isNullsLast, boolean isAcending) {
        Preconditions.checkNotNull(expression);
        this.expression = expression;
        this.isNullsLast = isNullsLast;
        this.isAscending = isAcending;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isNullsLast() {
        return this.isNullsLast;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrderByExpression that = (OrderByExpression)o;
            return this.isNullsLast == that.isNullsLast && this.isAscending == that.isAscending && this.expression.equals(that.expression);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNullsLast ? 0 : 1);
        result = 31 * result + (this.isAscending ? 0 : 1);
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public String toString() {
        return this.getExpression() + (this.isAscending ? "" : " DESC") + (this.isNullsLast ? " NULLS LAST" : "");
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.isNullsLast = input.readBoolean();
        this.isAscending = input.readBoolean();
        this.expression = ExpressionType.values()[WritableUtils.readVInt(input)].newInstance();
        this.expression.readFields(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeBoolean(this.isNullsLast);
        output.writeBoolean(this.isAscending);
        WritableUtils.writeVInt(output, ExpressionType.valueOf(this.expression).ordinal());
        this.expression.write(output);
    }
}

