/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.AddExpression;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;

public class LongAddExpression
extends AddExpression {
    public LongAddExpression() {
    }

    public LongAddExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        long finalResult = 0L;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr) || ptr.getLength() == 0) {
                return false;
            }
            long childvalue = child.getDataType().getCodec().decodeLong(ptr, child.getSortOrder());
            finalResult += childvalue;
        }
        byte[] resultPtr = new byte[PLong.INSTANCE.getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(finalResult, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PLong.INSTANCE;
    }

    @Override
    public ArithmeticExpression clone(List<Expression> children) {
        return new LongAddExpression(children);
    }
}

