/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.AddExpression;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PLong;

public class DateAddExpression
extends AddExpression {
    private static final BigDecimal BD_MILLIS_IN_DAY = BigDecimal.valueOf(86400000L);

    public DateAddExpression() {
    }

    public DateAddExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        long finalResult = 0L;
        for (int i = 0; i < this.children.size(); ++i) {
            long value;
            if (!((Expression)this.children.get(i)).evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType type = ((Expression)this.children.get(i)).getDataType();
            SortOrder sortOrder = ((Expression)this.children.get(i)).getSortOrder();
            if (type == PDecimal.INSTANCE) {
                BigDecimal bd = (BigDecimal)PDecimal.INSTANCE.toObject(ptr, sortOrder);
                value = bd.multiply(BD_MILLIS_IN_DAY).longValue();
            } else {
                value = type.isCoercibleTo(PLong.INSTANCE) ? type.getCodec().decodeLong(ptr, sortOrder) * 86400000L : (type.isCoercibleTo(PDouble.INSTANCE) ? (long)(type.getCodec().decodeDouble(ptr, sortOrder) * 8.64E7) : type.getCodec().decodeLong(ptr, sortOrder));
            }
            finalResult += value;
        }
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(finalResult, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDate.INSTANCE;
    }

    @Override
    public ArithmeticExpression clone(List<Expression> children) {
        return new DateAddExpression(children);
    }
}

