/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.util.ExpressionUtil;

public class CaseExpression
extends BaseCompoundExpression {
    private static final int FULLY_EVALUATE = -1;
    private short evalIndex = (short)-1;
    private boolean foundIndex;
    private PDataType returnType;

    public CaseExpression() {
    }

    public static Expression create(List<Expression> children) throws SQLException {
        CaseExpression caseExpression = new CaseExpression(CaseExpression.coerceIfNecessary(children));
        if (ExpressionUtil.isConstant(caseExpression)) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            int index = caseExpression.evaluateIndexOf(null, ptr);
            if (index < 0) {
                return LiteralExpression.newConstant(null, caseExpression.getDeterminism());
            }
            return caseExpression.getChildren().get(index);
        }
        return caseExpression;
    }

    private static List<Expression> coerceIfNecessary(List<Expression> children) throws SQLException {
        boolean isChildTypeUnknown = false;
        PDataType returnType = children.get(0).getDataType();
        for (int i = 2; i < children.size(); i += 2) {
            Expression child = children.get(i);
            PDataType childType = child.getDataType();
            if (childType == null) {
                isChildTypeUnknown = true;
                continue;
            }
            if (returnType == null) {
                returnType = childType;
                isChildTypeUnknown = true;
                continue;
            }
            if (returnType == childType || childType.isCoercibleTo(returnType)) continue;
            if (returnType.isCoercibleTo(childType)) {
                returnType = childType;
                continue;
            }
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_MISMATCH).setMessage("Case expressions must have common type: " + returnType + " cannot be coerced to " + childType).build().buildException();
        }
        if (isChildTypeUnknown && returnType != null && returnType.isCoercibleTo(PDecimal.INSTANCE)) {
            returnType = PDecimal.INSTANCE;
        }
        List<Expression> newChildren = children;
        for (int i = 0; i < children.size(); i += 2) {
            Expression child = children.get(i);
            PDataType childType = child.getDataType();
            if (childType == returnType) continue;
            if (newChildren == children) {
                newChildren = new ArrayList<Expression>(children);
            }
            newChildren.set(i, CoerceExpression.create(child, returnType));
        }
        return newChildren;
    }

    public CaseExpression(List<Expression> children) {
        super(children);
        this.returnType = children.get(0).getDataType();
    }

    private boolean isPartiallyEvaluating() {
        return this.evalIndex != -1;
    }

    public boolean hasElse() {
        return this.children.size() % 2 != 0;
    }

    @Override
    public boolean isNullable() {
        if (super.isNullable() || !this.hasElse()) {
            return true;
        }
        return ((Expression)this.children.get(this.children.size() - 1)).isNullable();
    }

    @Override
    public PDataType getDataType() {
        return this.returnType;
    }

    @Override
    public void reset() {
        this.foundIndex = false;
        this.evalIndex = 0;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.returnType = PDataType.values()[WritableUtils.readVInt(input)];
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVInt(output, this.returnType.ordinal());
    }

    public int evaluateIndexOf(Tuple tuple, ImmutableBytesWritable ptr) {
        int i;
        if (this.foundIndex) {
            return this.evalIndex;
        }
        int size = this.children.size();
        int n = i = this.isPartiallyEvaluating() ? this.evalIndex : 0;
        while (i < size) {
            if (i + 1 == size) {
                return i;
            }
            boolean evaluated = ((Expression)this.children.get(i + 1)).evaluate(tuple, ptr);
            if (evaluated && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr))) {
                if (this.isPartiallyEvaluating()) {
                    this.foundIndex = true;
                }
                return i;
            }
            if (this.isPartiallyEvaluating()) {
                if (evaluated || tuple.isImmutable()) {
                    this.evalIndex = (short)(this.evalIndex + 2);
                } else {
                    return -1;
                }
            }
            i += 2;
        }
        return size;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int index = this.evaluateIndexOf(tuple, ptr);
        if (index < 0) {
            return false;
        }
        if (index == this.children.size()) {
            ptr.set(PDataType.NULL_BYTES);
            return true;
        }
        return ((Expression)this.children.get(index)).evaluate(tuple, ptr);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("CASE ");
        for (int i = 0; i < this.children.size() - 1; i += 2) {
            buf.append("WHEN ");
            buf.append(this.children.get(i + 1));
            buf.append(" THEN ");
            buf.append(this.children.get(i));
        }
        if (this.hasElse()) {
            buf.append(" ELSE " + this.children.get(this.children.size() - 1));
        }
        buf.append(" END");
        return buf.toString();
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return super.requiresFinalEvaluation() || this.hasElse();
    }
}

