/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.CeilDecimalExpression;
import org.apache.phoenix.expression.function.CeilTimestampExpression;
import org.apache.phoenix.expression.function.FloorDateExpression;
import org.apache.phoenix.expression.function.FloorDecimalExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;

public abstract class BaseExpression
implements Expression {
    private static ExpressionComparabilityWrapper[] WRAPPERS = new ExpressionComparabilityWrapper[CompareFilter.CompareOp.values().length];

    private static ExpressionComparabilityWrapper getWrapper(CompareFilter.CompareOp op) {
        ExpressionComparabilityWrapper wrapper = WRAPPERS[op.ordinal()];
        if (wrapper == null) {
            throw new IllegalStateException("Unexpected compare op of " + (Object)((Object)op) + " for row value constructor");
        }
        return wrapper;
    }

    public static Expression coerce(Expression lhs, Expression rhs, CompareFilter.CompareOp op) throws SQLException {
        return BaseExpression.coerce(lhs, rhs, BaseExpression.getWrapper(op));
    }

    public static Expression coerce(Expression lhs, Expression rhs, ExpressionComparabilityWrapper wrapper) throws SQLException {
        if (lhs instanceof RowValueConstructorExpression && rhs instanceof RowValueConstructorExpression) {
            int i;
            ArrayList<Expression> coercedNodes = Lists.newArrayListWithExpectedSize(Math.max(lhs.getChildren().size(), rhs.getChildren().size()));
            for (i = 0; i < Math.min(lhs.getChildren().size(), rhs.getChildren().size()); ++i) {
                coercedNodes.add(BaseExpression.coerce(lhs.getChildren().get(i), rhs.getChildren().get(i), wrapper));
            }
            while (i < lhs.getChildren().size()) {
                coercedNodes.add(BaseExpression.coerce(lhs.getChildren().get(i), null, wrapper));
                ++i;
            }
            while (i < rhs.getChildren().size()) {
                coercedNodes.add(BaseExpression.coerce(null, rhs.getChildren().get(i), wrapper));
                ++i;
            }
            BaseExpression.trimTrailingNulls(coercedNodes);
            return coercedNodes.equals(rhs.getChildren()) ? rhs : new RowValueConstructorExpression(coercedNodes, rhs.isStateless());
        }
        if (lhs instanceof RowValueConstructorExpression) {
            ArrayList<Expression> coercedNodes = Lists.newArrayListWithExpectedSize(Math.max(rhs.getChildren().size(), lhs.getChildren().size()));
            coercedNodes.add(BaseExpression.coerce(lhs.getChildren().get(0), rhs, wrapper));
            for (int i = 1; i < lhs.getChildren().size(); ++i) {
                coercedNodes.add(BaseExpression.coerce(lhs.getChildren().get(i), null, wrapper));
            }
            BaseExpression.trimTrailingNulls(coercedNodes);
            return coercedNodes.equals(rhs.getChildren()) ? rhs : new RowValueConstructorExpression(coercedNodes, rhs.isStateless());
        }
        if (rhs instanceof RowValueConstructorExpression) {
            ArrayList<Expression> coercedNodes = Lists.newArrayListWithExpectedSize(Math.max(rhs.getChildren().size(), lhs.getChildren().size()));
            coercedNodes.add(BaseExpression.coerce(lhs, rhs.getChildren().get(0), wrapper));
            for (int i = 1; i < rhs.getChildren().size(); ++i) {
                coercedNodes.add(BaseExpression.coerce(null, rhs.getChildren().get(i), wrapper));
            }
            BaseExpression.trimTrailingNulls(coercedNodes);
            return coercedNodes.equals(rhs.getChildren()) ? rhs : new RowValueConstructorExpression(coercedNodes, rhs.isStateless());
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return LiteralExpression.newConstant(null, lhs.getDataType(), lhs.getDeterminism());
        }
        if (rhs.getDataType() != null && lhs.getDataType() != null && !rhs.getDataType().isCastableTo(lhs.getDataType())) {
            throw TypeMismatchException.newException(lhs.getDataType(), rhs.getDataType());
        }
        return wrapper.wrap(lhs, rhs);
    }

    private static void trimTrailingNulls(List<Expression> expressions) {
        Expression e;
        for (int i = expressions.size() - 1; i >= 0 && (e = expressions.get(i)) instanceof LiteralExpression && ((LiteralExpression)e).getValue() == null; --i) {
            expressions.remove(i);
        }
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Integer getMaxLength() {
        return null;
    }

    @Override
    public Integer getScale() {
        return null;
    }

    @Override
    public SortOrder getSortOrder() {
        return SortOrder.getDefault();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
    }

    @Override
    public void write(DataOutput output) throws IOException {
    }

    @Override
    public void reset() {
    }

    protected final <T> List<T> acceptChildren(ExpressionVisitor<T> visitor, Iterator<Expression> iterator) {
        if (iterator == null) {
            iterator = visitor.defaultIterator(this);
        }
        List l = Collections.emptyList();
        while (iterator.hasNext()) {
            Expression child = iterator.next();
            T t = child.accept(visitor);
            if (t == null) continue;
            if (l.isEmpty()) {
                l = new ArrayList(this.getChildren().size());
            }
            l.add(t);
        }
        return l;
    }

    @Override
    public Determinism getDeterminism() {
        return Determinism.ALWAYS;
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return false;
    }

    static {
        BaseExpression.WRAPPERS[CompareFilter.CompareOp.LESS.ordinal()] = new ExpressionComparabilityWrapper(){

            @Override
            public Expression wrap(Expression lhs, Expression rhs) throws SQLException {
                Expression e = rhs;
                PDataType rhsType = rhs.getDataType();
                PDataType lhsType = lhs.getDataType();
                if (rhsType == PDecimal.INSTANCE && lhsType != PDecimal.INSTANCE) {
                    e = FloorDecimalExpression.create(rhs);
                } else if ((rhsType == PTimestamp.INSTANCE || rhsType == PUnsignedTimestamp.INSTANCE) && lhsType != PTimestamp.INSTANCE && lhsType != PUnsignedTimestamp.INSTANCE) {
                    e = FloorDateExpression.create(rhs, TimeUnit.MILLISECOND);
                }
                e = CoerceExpression.create(e, lhsType, lhs.getSortOrder(), lhs.getMaxLength());
                return e;
            }
        };
        BaseExpression.WRAPPERS[CompareFilter.CompareOp.LESS_OR_EQUAL.ordinal()] = WRAPPERS[CompareFilter.CompareOp.LESS.ordinal()];
        BaseExpression.WRAPPERS[CompareFilter.CompareOp.GREATER.ordinal()] = new ExpressionComparabilityWrapper(){

            @Override
            public Expression wrap(Expression lhs, Expression rhs) throws SQLException {
                Expression e = rhs;
                PDataType rhsType = rhs.getDataType();
                PDataType lhsType = lhs.getDataType();
                if (rhsType == PDecimal.INSTANCE && lhsType != PDecimal.INSTANCE) {
                    e = CeilDecimalExpression.create(rhs);
                } else if ((rhsType == PTimestamp.INSTANCE || rhsType == PUnsignedTimestamp.INSTANCE) && lhsType != PTimestamp.INSTANCE && lhsType != PUnsignedTimestamp.INSTANCE) {
                    e = CeilTimestampExpression.create(rhs);
                }
                e = CoerceExpression.create(e, lhsType, lhs.getSortOrder(), lhs.getMaxLength());
                return e;
            }
        };
        BaseExpression.WRAPPERS[CompareFilter.CompareOp.GREATER_OR_EQUAL.ordinal()] = WRAPPERS[CompareFilter.CompareOp.GREATER.ordinal()];
        BaseExpression.WRAPPERS[CompareFilter.CompareOp.EQUAL.ordinal()] = new ExpressionComparabilityWrapper(){

            @Override
            public Expression wrap(Expression lhs, Expression rhs) throws SQLException {
                PDataType lhsType = lhs.getDataType();
                Expression e = CoerceExpression.create(rhs, lhsType, lhs.getSortOrder(), lhs.getMaxLength());
                return e;
            }
        };
    }

    public static interface ExpressionComparabilityWrapper {
        public Expression wrap(Expression var1, Expression var2) throws SQLException;
    }
}

