/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;

public abstract class AndOrExpression
extends BaseCompoundExpression {
    private BitSet partialEvalState;

    public AndOrExpression() {
    }

    public AndOrExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public PDataType getDataType() {
        return PBoolean.INSTANCE;
    }

    @Override
    public void reset() {
        if (this.partialEvalState == null) {
            this.partialEvalState = new BitSet(this.children.size());
        } else {
            this.partialEvalState.clear();
        }
        super.reset();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean isNull = false;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (this.partialEvalState != null && this.partialEvalState.get(i)) continue;
            if (child.evaluate(tuple, ptr)) {
                if (this.isStopValue((Boolean)PBoolean.INSTANCE.toObject(ptr, child.getDataType()))) {
                    return true;
                }
                if (this.partialEvalState == null) continue;
                this.partialEvalState.set(i);
                continue;
            }
            isNull = true;
        }
        return !isNull;
    }

    protected abstract boolean isStopValue(Boolean var1);
}

