/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.DelegateQueryPlan;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.iterate.DefaultParallelScanGrouper;
import org.apache.phoenix.iterate.FilterResultIterator;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.join.HashCacheClient;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;

public class HashJoinPlan
extends DelegateQueryPlan {
    private static final Log LOG = LogFactory.getLog(HashJoinPlan.class);
    private final SelectStatement statement;
    private final HashJoinInfo joinInfo;
    private final SubPlan[] subPlans;
    private final boolean recompileWhereClause;
    private List<SQLCloseable> dependencies;
    private HashCacheClient hashClient;
    private int maxServerCacheTimeToLive;
    private AtomicLong firstJobEndTime;
    private List<Expression> keyRangeExpressions;

    public static HashJoinPlan create(SelectStatement statement, QueryPlan plan, HashJoinInfo joinInfo, SubPlan[] subPlans) {
        if (!(plan instanceof HashJoinPlan)) {
            return new HashJoinPlan(statement, plan, joinInfo, subPlans, joinInfo == null);
        }
        HashJoinPlan hashJoinPlan = (HashJoinPlan)plan;
        assert (hashJoinPlan.joinInfo == null && hashJoinPlan.delegate instanceof BaseQueryPlan);
        SubPlan[] mergedSubPlans = new SubPlan[hashJoinPlan.subPlans.length + subPlans.length];
        int i = 0;
        for (SubPlan subPlan : hashJoinPlan.subPlans) {
            mergedSubPlans[i++] = subPlan;
        }
        for (SubPlan subPlan : subPlans) {
            mergedSubPlans[i++] = subPlan;
        }
        return new HashJoinPlan(statement, hashJoinPlan.delegate, joinInfo, mergedSubPlans, true);
    }

    private HashJoinPlan(SelectStatement statement, QueryPlan plan, HashJoinInfo joinInfo, SubPlan[] subPlans, boolean recompileWhereClause) {
        super(plan);
        this.statement = statement;
        this.joinInfo = joinInfo;
        this.subPlans = subPlans;
        this.recompileWhereClause = recompileWhereClause;
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        return this.iterator(DefaultParallelScanGrouper.getInstance());
    }

    @Override
    public ResultIterator iterator(ParallelScanGrouper scanGrouper) throws SQLException {
        ResultIterator iterator;
        boolean hasKeyRangeExpressions;
        int count = this.subPlans.length;
        PhoenixConnection connection = this.getContext().getConnection();
        ConnectionQueryServices services = connection.getQueryServices();
        ThreadPoolExecutor executor = services.getExecutor();
        ArrayList<Future<Object>> futures = Lists.newArrayListWithExpectedSize(count);
        this.dependencies = Lists.newArrayList();
        if (this.joinInfo != null) {
            this.hashClient = new HashCacheClient(this.delegate.getContext().getConnection());
            this.maxServerCacheTimeToLive = services.getProps().getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000);
            this.firstJobEndTime = new AtomicLong(0L);
            this.keyRangeExpressions = new CopyOnWriteArrayList<Expression>();
        }
        int i = 0;
        while (i < count) {
            final int index = i++;
            futures.add(executor.submit(new JobManager.JobCallable<Object>(){

                @Override
                public Object call() throws Exception {
                    return HashJoinPlan.this.subPlans[index].execute(HashJoinPlan.this);
                }

                @Override
                public Object getJobId() {
                    return HashJoinPlan.this;
                }
            }));
        }
        SQLException firstException = null;
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                Object result = ((Future)futures.get(i2)).get();
                this.subPlans[i2].postProcess(result, this);
                continue;
            }
            catch (InterruptedException e) {
                if (firstException != null) continue;
                firstException = new SQLException("Sub plan [" + i2 + "] execution interrupted.", e);
                continue;
            }
            catch (ExecutionException e) {
                if (firstException != null) continue;
                firstException = new SQLException("Encountered exception in sub plan [" + i2 + "] execution.", e.getCause());
            }
        }
        if (firstException != null) {
            SQLCloseables.closeAllQuietly(this.dependencies);
            throw firstException;
        }
        Expression postFilter = null;
        boolean bl = hasKeyRangeExpressions = this.keyRangeExpressions != null && !this.keyRangeExpressions.isEmpty();
        if (this.recompileWhereClause || hasKeyRangeExpressions) {
            StatementContext context = this.delegate.getContext();
            PTable table = context.getCurrentTable().getTable();
            ParseNode viewWhere = table.getViewStatement() == null ? null : new SQLParser(table.getViewStatement()).parseQuery().getWhere();
            context.setResolver(FromCompiler.getResolverForQuery((SelectStatement)this.delegate.getStatement(), this.delegate.getContext().getConnection()));
            if (this.recompileWhereClause) {
                postFilter = WhereCompiler.compile(this.delegate.getContext(), this.delegate.getStatement(), viewWhere, null);
            }
            if (hasKeyRangeExpressions) {
                WhereCompiler.compile(this.delegate.getContext(), this.delegate.getStatement(), viewWhere, this.keyRangeExpressions, true, null);
            }
        }
        if (this.joinInfo != null) {
            Scan scan = this.delegate.getContext().getScan();
            HashJoinInfo.serializeHashJoinIntoScan(scan, this.joinInfo);
        }
        ResultIterator resultIterator = iterator = this.joinInfo == null ? this.delegate.iterator(scanGrouper) : ((BaseQueryPlan)this.delegate).iterator(this.dependencies, scanGrouper);
        if (this.statement.getInnerSelectStatement() != null && postFilter != null) {
            iterator = new FilterResultIterator(iterator, postFilter);
        }
        return iterator;
    }

    private Expression createKeyRangeExpression(Expression lhsExpression, Expression rhsExpression, List<Expression> rhsValues, ImmutableBytesWritable ptr) throws SQLException {
        if (rhsValues.isEmpty()) {
            return LiteralExpression.newConstant((Object)false, (PDataType)PBoolean.INSTANCE, Determinism.ALWAYS);
        }
        rhsValues.add(0, lhsExpression);
        return InListExpression.create(rhsValues, false, ptr);
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        int i;
        ArrayList<String> planSteps = Lists.newArrayList(this.delegate.getExplainPlan().getPlanSteps());
        int count = this.subPlans.length;
        for (i = 0; i < count; ++i) {
            planSteps.addAll(this.subPlans[i].getPreSteps(this));
        }
        for (i = 0; i < count; ++i) {
            planSteps.addAll(this.subPlans[i].getPostSteps(this));
        }
        if (this.joinInfo != null && this.joinInfo.getPostJoinFilterExpression() != null) {
            planSteps.add("    AFTER-JOIN SERVER FILTER BY " + this.joinInfo.getPostJoinFilterExpression().toString());
        }
        if (this.joinInfo != null && this.joinInfo.getLimit() != null) {
            planSteps.add("    JOIN-SCANNER " + this.joinInfo.getLimit() + " ROW LIMIT");
        }
        return new ExplainPlan(planSteps);
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    public static class HashSubPlan
    implements SubPlan {
        private final int index;
        private final QueryPlan plan;
        private final List<Expression> hashExpressions;
        private final boolean singleValueOnly;
        private final Expression keyRangeLhsExpression;
        private final Expression keyRangeRhsExpression;

        public HashSubPlan(int index, QueryPlan subPlan, List<Expression> hashExpressions, boolean singleValueOnly, Expression keyRangeLhsExpression, Expression keyRangeRhsExpression) {
            this.index = index;
            this.plan = subPlan;
            this.hashExpressions = hashExpressions;
            this.singleValueOnly = singleValueOnly;
            this.keyRangeLhsExpression = keyRangeLhsExpression;
            this.keyRangeRhsExpression = keyRangeRhsExpression;
        }

        @Override
        public Object execute(HashJoinPlan parent) throws SQLException {
            ScanRanges ranges = parent.delegate.getContext().getScanRanges();
            ArrayList<Expression> keyRangeRhsValues = null;
            if (this.keyRangeRhsExpression != null) {
                keyRangeRhsValues = Lists.newArrayList();
            }
            ServerCacheClient.ServerCache cache = null;
            if (this.hashExpressions != null) {
                cache = parent.hashClient.addHashCache(ranges, this.plan.iterator(), this.plan.getEstimatedSize(), this.hashExpressions, this.singleValueOnly, parent.delegate.getTableRef(), this.keyRangeRhsExpression, keyRangeRhsValues);
                long endTime = System.currentTimeMillis();
                boolean isSet = parent.firstJobEndTime.compareAndSet(0L, endTime);
                if (!isSet && endTime - parent.firstJobEndTime.get() > (long)parent.maxServerCacheTimeToLive) {
                    LOG.warn(LogUtil.addCustomAnnotations("Hash plan [" + this.index + "] execution seems too slow. Earlier hash cache(s) might have expired on servers.", parent.delegate.getContext().getConnection()));
                }
            } else {
                assert (this.keyRangeRhsExpression != null);
                ResultIterator iterator = this.plan.iterator();
                Tuple result = iterator.next();
                while (result != null) {
                    keyRangeRhsValues.add(HashCacheClient.evaluateKeyExpression(this.keyRangeRhsExpression, result, this.plan.getContext().getTempPtr()));
                    result = iterator.next();
                }
            }
            if (keyRangeRhsValues != null) {
                parent.keyRangeExpressions.add(parent.createKeyRangeExpression(this.keyRangeLhsExpression, this.keyRangeRhsExpression, keyRangeRhsValues, this.plan.getContext().getTempPtr()));
            }
            return cache;
        }

        @Override
        public void postProcess(Object result, HashJoinPlan parent) throws SQLException {
            ServerCacheClient.ServerCache cache = (ServerCacheClient.ServerCache)result;
            if (cache != null) {
                parent.joinInfo.getJoinIds()[this.index].set(cache.getId());
                parent.dependencies.add(cache);
            }
        }

        @Override
        public List<String> getPreSteps(HashJoinPlan parent) throws SQLException {
            boolean skipMerge;
            ArrayList<String> steps = Lists.newArrayList();
            boolean earlyEvaluation = parent.joinInfo.earlyEvaluation()[this.index];
            boolean bl = skipMerge = parent.joinInfo.getSchemas()[this.index].getFieldCount() == 0;
            if (this.hashExpressions != null) {
                steps.add("    PARALLEL " + parent.joinInfo.getJoinTypes()[this.index].toString().toUpperCase() + "-JOIN TABLE " + this.index + (earlyEvaluation ? "" : "(DELAYED EVALUATION)") + (skipMerge ? " (SKIP MERGE)" : ""));
            } else {
                steps.add("    SKIP-SCAN-JOIN TABLE " + this.index);
            }
            for (String step : this.plan.getExplainPlan().getPlanSteps()) {
                steps.add("        " + step);
            }
            return steps;
        }

        @Override
        public List<String> getPostSteps(HashJoinPlan parent) throws SQLException {
            if (this.keyRangeLhsExpression == null) {
                return Collections.emptyList();
            }
            String step = "    DYNAMIC SERVER FILTER BY " + this.keyRangeLhsExpression.toString() + " IN (" + this.keyRangeRhsExpression.toString() + ")";
            return Collections.singletonList(step);
        }
    }

    public static class WhereClauseSubPlan
    implements SubPlan {
        private final QueryPlan plan;
        private final SelectStatement select;
        private final boolean expectSingleRow;

        public WhereClauseSubPlan(QueryPlan plan, SelectStatement select, boolean expectSingleRow) {
            this.plan = plan;
            this.select = select;
            this.expectSingleRow = expectSingleRow;
        }

        @Override
        public Object execute(HashJoinPlan parent) throws SQLException {
            ArrayList<Object> values = Lists.newArrayList();
            ResultIterator iterator = this.plan.iterator();
            RowProjector projector = this.plan.getProjector();
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            int columnCount = projector.getColumnCount();
            int rowCount = 0;
            PDataType baseType = PVarbinary.INSTANCE;
            Tuple tuple = iterator.next();
            while (tuple != null) {
                if (this.expectSingleRow && rowCount >= 1) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_ROW_SUBQUERY_RETURNS_MULTIPLE_ROWS).build().buildException();
                }
                if (columnCount == 1) {
                    ColumnProjector columnProjector = projector.getColumnProjector(0);
                    baseType = columnProjector.getExpression().getDataType();
                    Object value = columnProjector.getValue(tuple, baseType, ptr);
                    values.add(value);
                } else {
                    ArrayList<Expression> expressions = Lists.newArrayListWithExpectedSize(columnCount);
                    for (int i = 0; i < columnCount; ++i) {
                        ColumnProjector columnProjector = projector.getColumnProjector(i);
                        PDataType type = columnProjector.getExpression().getDataType();
                        Object value = columnProjector.getValue(tuple, type, ptr);
                        expressions.add(LiteralExpression.newConstant(value, type));
                    }
                    RowValueConstructorExpression expression = new RowValueConstructorExpression(expressions, true);
                    baseType = expression.getDataType();
                    expression.evaluate(null, ptr);
                    values.add(baseType.toObject(ptr));
                }
                ++rowCount;
                tuple = iterator.next();
            }
            PhoenixArray result = this.expectSingleRow ? (values.isEmpty() ? null : values.get(0)) : PArrayDataType.instantiatePhoenixArray(baseType, values.toArray());
            parent.getContext().setSubqueryResult(this.select, result);
            return null;
        }

        @Override
        public void postProcess(Object result, HashJoinPlan parent) throws SQLException {
        }

        @Override
        public List<String> getPreSteps(HashJoinPlan parent) throws SQLException {
            ArrayList<String> steps = Lists.newArrayList();
            steps.add("    EXECUTE " + (this.expectSingleRow ? "SINGLE" : "MULTIPLE") + "-ROW SUBQUERY");
            for (String step : this.plan.getExplainPlan().getPlanSteps()) {
                steps.add("        " + step);
            }
            return steps;
        }

        @Override
        public List<String> getPostSteps(HashJoinPlan parent) throws SQLException {
            return Collections.emptyList();
        }
    }

    protected static interface SubPlan {
        public Object execute(HashJoinPlan var1) throws SQLException;

        public void postProcess(Object var1, HashJoinPlan var2) throws SQLException;

        public List<String> getPreSteps(HashJoinPlan var1) throws SQLException;

        public List<String> getPostSteps(HashJoinPlan var1) throws SQLException;
    }
}

