/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.RowKeyExpression;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.DistinctAggregatingResultIterator;
import org.apache.phoenix.iterate.FilterAggregatingResultIterator;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.OrderedAggregatingResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.iterate.UngroupedAggregatingResultIterator;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PInteger;

public class AggregatePlan
extends BaseQueryPlan {
    private final Aggregators aggregators;
    private final Expression having;
    private List<KeyRange> splits;
    private List<List<Scan>> scans;

    public AggregatePlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, OrderByCompiler.OrderBy orderBy, ParallelIteratorFactory parallelIteratorFactory, GroupByCompiler.GroupBy groupBy, Expression having) {
        super(context, statement, table, projector, context.getBindManager().getParameterMetaData(), limit, orderBy, groupBy, parallelIteratorFactory);
        this.having = having;
        this.aggregators = context.getAggregationManager().getAggregators();
    }

    public Expression getHaving() {
        return this.having;
    }

    @Override
    public List<KeyRange> getSplits() {
        if (this.splits == null) {
            return Collections.emptyList();
        }
        return this.splits;
    }

    @Override
    public List<List<Scan>> getScans() {
        if (this.scans == null) {
            return Collections.emptyList();
        }
        return this.scans;
    }

    private ParallelIteratorFactory wrapParallelIteratorFactory() {
        ConnectionQueryServices services = this.context.getConnection().getQueryServices();
        ParallelIteratorFactory innerFactory = this.groupBy.isEmpty() || this.groupBy.isOrderPreserving() ? new SpoolingResultIterator.SpoolingResultIteratorFactory(services) : new OrderingResultIteratorFactory(services);
        if (this.parallelIteratorFactory == null) {
            return innerFactory;
        }
        return new WrappingResultIteratorFactory(innerFactory, this.parallelIteratorFactory);
    }

    @Override
    protected ResultIterator newIterator(ParallelScanGrouper scanGrouper) throws SQLException {
        if (this.groupBy.isEmpty()) {
            UngroupedAggregateRegionObserver.serializeIntoScan(this.context.getScan());
        } else {
            GroupedAggregateRegionObserver.serializeIntoScan(this.context.getScan(), this.groupBy.getScanAttribName(), this.groupBy.getKeyExpressions());
            if (this.limit != null && this.orderBy.getOrderByExpressions().isEmpty() && this.having == null && (this.statement.isDistinct() && !this.statement.isAggregate() || !this.statement.isDistinct() && (this.context.getAggregationManager().isEmpty() || "_OrderedGroupByExpressions".equals(this.groupBy.getScanAttribName())))) {
                this.context.getScan().setAttribute("_GroupByLimit", PInteger.INSTANCE.toBytes(this.limit));
            }
        }
        ParallelIterators parallelIterators = new ParallelIterators((QueryPlan)this, null, this.wrapParallelIteratorFactory());
        this.splits = parallelIterators.getSplits();
        this.scans = parallelIterators.getScans();
        AggregatingResultIterator aggResultIterator = this.groupBy.isEmpty() ? new UngroupedAggregatingResultIterator(new ConcatResultIterator(parallelIterators), this.aggregators) : new GroupedAggregatingResultIterator(new MergeSortRowKeyResultIterator(parallelIterators), this.aggregators);
        if (this.having != null) {
            aggResultIterator = new FilterAggregatingResultIterator(aggResultIterator, this.having);
        }
        if (this.statement.isDistinct() && this.statement.isAggregate()) {
            aggResultIterator = new DistinctAggregatingResultIterator(aggResultIterator, this.getProjector());
        }
        ResultIterator resultScanner = aggResultIterator;
        if (this.orderBy.getOrderByExpressions().isEmpty()) {
            if (this.limit != null) {
                resultScanner = new LimitingResultIterator(aggResultIterator, this.limit);
            }
        } else {
            int thresholdBytes = this.context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            resultScanner = new OrderedAggregatingResultIterator(aggResultIterator, this.orderBy.getOrderByExpressions(), thresholdBytes, this.limit);
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            resultScanner = new SequenceResultIterator(resultScanner, this.context.getSequenceManager());
        }
        return resultScanner;
    }

    @Override
    public boolean useRoundRobinIterator() throws SQLException {
        return false;
    }

    private static class WrappingResultIteratorFactory
    implements ParallelIteratorFactory {
        private final ParallelIteratorFactory innerFactory;
        private final ParallelIteratorFactory outerFactory;

        public WrappingResultIteratorFactory(ParallelIteratorFactory innerFactory, ParallelIteratorFactory outerFactory) {
            this.innerFactory = innerFactory;
            this.outerFactory = outerFactory;
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan) throws SQLException {
            PeekingResultIterator iterator = this.innerFactory.newIterator(context, scanner, scan);
            return this.outerFactory.newIterator(context, iterator, scan);
        }
    }

    private static class OrderingResultIteratorFactory
    implements ParallelIteratorFactory {
        private final QueryServices services;

        public OrderingResultIteratorFactory(QueryServices services) {
            this.services = services;
        }

        @Override
        public PeekingResultIterator newIterator(StatementContext context, ResultIterator scanner, Scan scan) throws SQLException {
            RowKeyExpression expression = RowKeyExpression.INSTANCE;
            OrderByExpression orderByExpression = new OrderByExpression(expression, false, true);
            int threshold = this.services.getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            return new OrderedResultIterator(scanner, Collections.singletonList(orderByExpression), threshold);
        }
    }
}

