/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TimeKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UngroupedAggregateRegionObserver
extends BaseScannerRegionObserver {
    public static final String UNGROUPED_AGG = "UngroupedAgg";
    public static final String DELETE_AGG = "DeleteAgg";
    public static final String UPSERT_SELECT_TABLE = "UpsertSelectTable";
    public static final String UPSERT_SELECT_EXPRS = "UpsertSelectExprs";
    public static final String DELETE_CQ = "DeleteCQ";
    public static final String DELETE_CF = "DeleteCF";
    public static final String EMPTY_CF = "EmptyCF";
    private static final Logger logger = LoggerFactory.getLogger(UngroupedAggregateRegionObserver.class);
    private KeyValueBuilder kvBuilder;

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
        this.kvBuilder = GenericKeyValueBuilder.INSTANCE;
    }

    private static void commitBatch(Region region, List<Mutation> mutations, byte[] indexUUID) throws IOException {
        if (indexUUID != null) {
            for (Mutation m : mutations) {
                m.setAttribute("IdxUUID", indexUUID);
            }
        }
        Mutation[] mutationArray = new Mutation[mutations.size()];
        region.batchMutate(mutations.toArray(mutationArray), 0L, 0L);
    }

    public static void serializeIntoScan(Scan scan) {
        scan.setAttribute("_UngroupedAgg", QueryConstants.TRUE);
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        s = super.preScannerOpen(e, scan, s);
        if (ScanUtil.isAnalyzeTable(scan)) {
            if (!ScanUtil.isLocalIndex(scan)) {
                scan.getFamilyMap().clear();
            }
            scan.setStartRow(HConstants.EMPTY_START_ROW);
            scan.setStopRow(HConstants.EMPTY_END_ROW);
            scan.setFilter(null);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, final Scan scan, RegionScanner s) throws IOException {
        boolean buildLocalIndex;
        byte[] localIndexBytes;
        int offset = 0;
        Region region = c.getEnvironment().getRegion();
        long ts = scan.getTimeRange().getMax();
        StatisticsCollector stats = null;
        boolean localIndexScan = ScanUtil.isLocalIndex(scan);
        if (ScanUtil.isAnalyzeTable(scan)) {
            byte[] gp_width_bytes = scan.getAttribute("_GUIDEPOST_WIDTH_BYTES");
            byte[] gp_per_region_bytes = scan.getAttribute("_GUIDEPOST_PER_REGION");
            stats = new StatisticsCollector(c.getEnvironment(), region.getRegionInfo().getTable().getNameAsString(), ts, gp_width_bytes, gp_per_region_bytes);
        }
        if (localIndexScan) {
            offset = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset(scan, offset);
        }
        List<IndexMaintainer> indexMaintainers = (localIndexBytes = scan.getAttribute("_LocalIndexBuild")) == null ? null : IndexMaintainer.deserialize(localIndexBytes);
        List<Mutation> indexMutations = localIndexBytes == null ? Collections.emptyList() : Lists.newArrayListWithExpectedSize(1024);
        RegionScanner theScanner = s;
        byte[] indexUUID = scan.getAttribute("IdxUUID");
        PTable projectedTable = null;
        List<Expression> selectExpressions = null;
        byte[] upsertSelectTable = scan.getAttribute("_UpsertSelectTable");
        boolean isUpsert = false;
        boolean isDelete = false;
        byte[] deleteCQ = null;
        byte[] deleteCF = null;
        Object values = null;
        byte[] emptyCF = null;
        ArrayList<byte[]> cfsToDelete = new ArrayList<byte[]>();
        ImmutableBytesWritable ptr = null;
        if (upsertSelectTable != null) {
            isUpsert = true;
            projectedTable = UngroupedAggregateRegionObserver.deserializeTable(upsertSelectTable);
            selectExpressions = UngroupedAggregateRegionObserver.deserializeExpressions(scan.getAttribute("_UpsertSelectExprs"));
            values = new byte[projectedTable.getPKColumns().size()][];
            ptr = new ImmutableBytesWritable();
        } else {
            byte[] isDeleteAgg = scan.getAttribute("_DeleteAgg");
            boolean bl = isDelete = isDeleteAgg != null && Bytes.compareTo(PDataType.TRUE_BYTES, isDeleteAgg) == 0;
            if (!isDelete) {
                deleteCF = scan.getAttribute("_DeleteCF");
                deleteCQ = scan.getAttribute("_DeleteCQ");
            } else if (localIndexScan) {
                for (HColumnDescriptor cf : region.getTableDesc().getFamilies()) {
                    if (!cf.getNameAsString().startsWith("L#")) continue;
                    cfsToDelete.add(cf.getName());
                }
            } else {
                for (HColumnDescriptor cf : region.getTableDesc().getFamilies()) {
                    if (cf.getNameAsString().startsWith("L#")) continue;
                    cfsToDelete.add(cf.getName());
                }
            }
            emptyCF = scan.getAttribute("_EmptyCF");
        }
        if (localIndexBytes != null) {
            ptr = new ImmutableBytesWritable();
        }
        TupleProjector tupleProjector = null;
        byte[][] viewConstants = null;
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin(scan);
        TupleProjector p = TupleProjector.deserializeProjectorFromScan(scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
        if (localIndexScan && !isDelete || j == null && p != null) {
            if (dataColumns != null) {
                tupleProjector = IndexUtil.getTupleProjector(scan, dataColumns);
                viewConstants = IndexUtil.deserializeViewConstantsFromScan(scan);
            }
            ImmutableBytesWritable tempPtr = new ImmutableBytesWritable();
            theScanner = this.getWrappedScanner(c, theScanner, offset, scan, dataColumns, tupleProjector, c.getEnvironment().getRegion(), indexMaintainers == null ? null : indexMaintainers.get(0), viewConstants, p, tempPtr);
        }
        if (j != null) {
            theScanner = new HashJoinRegionScanner(theScanner, p, j, ScanUtil.getTenantId(scan), c.getEnvironment());
        }
        int batchSize = 0;
        List<Mutation> mutations = Collections.emptyList();
        boolean bl = buildLocalIndex = indexMaintainers != null && dataColumns == null && !localIndexScan;
        if (isDelete || isUpsert || deleteCQ != null && deleteCF != null || emptyCF != null || buildLocalIndex) {
            mutations = Lists.newArrayListWithExpectedSize(1024);
            batchSize = c.getEnvironment().getConfiguration().getInt("phoenix.mutate.batchSize", 1000);
        }
        ServerAggregators aggregators = ServerAggregators.deserialize(scan.getAttribute("_Aggs"), c.getEnvironment().getConfiguration());
        Aggregator[] rowAggregators = aggregators.getAggregators();
        boolean hasAny = false;
        MultiKeyValueTuple result = new MultiKeyValueTuple();
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Starting ungrouped coprocessor scan " + scan + " " + region.getRegionInfo(), ScanUtil.getCustomAnnotations(scan)));
        }
        long rowCount = 0L;
        final RegionScanner innerScanner = theScanner;
        region.startRegionOperation();
        try {
            RegionScanner regionScanner = innerScanner;
            synchronized (regionScanner) {
                boolean hasMore;
                do {
                    block67: {
                        ArrayList<Cell> results = new ArrayList<Cell>();
                        hasMore = innerScanner.nextRaw(results);
                        if (stats != null) {
                            stats.collectStatistics(results);
                        }
                        if (results.isEmpty()) continue;
                        ++rowCount;
                        result.setKeyValues(results);
                        try {
                            if (buildLocalIndex) {
                                for (IndexMaintainer maintainer : indexMaintainers) {
                                    if (results.isEmpty()) continue;
                                    result.getKey(ptr);
                                    ValueGetter valueGetter = maintainer.createGetterFromKeyValues(ImmutableBytesPtr.copyBytesIfNecessary(ptr), results);
                                    Put put = maintainer.buildUpdateMutation(this.kvBuilder, valueGetter, ptr, ts, c.getEnvironment().getRegion().getRegionInfo().getStartKey(), c.getEnvironment().getRegion().getRegionInfo().getEndKey());
                                    indexMutations.add(put);
                                }
                                result.setKeyValues(results);
                            } else if (isDelete) {
                                Cell firstKV = (Cell)results.get(0);
                                Delete delete = new Delete(firstKV.getRowArray(), firstKV.getRowOffset(), firstKV.getRowLength(), ts);
                                for (byte[] cf : cfsToDelete) {
                                    delete.addFamily(cf);
                                }
                                mutations.add(delete);
                            } else if (isUpsert) {
                                int i;
                                Arrays.fill((Object[])values, null);
                                List<PColumn> projectedColumns = projectedTable.getColumns();
                                for (i = 0; i < projectedTable.getPKColumns().size(); ++i) {
                                    Expression expression = selectExpressions.get(i);
                                    if (!expression.evaluate(result, ptr)) continue;
                                    values[i] = ptr.copyBytes();
                                    if (expression.getSortOrder() == ((PColumn)projectedColumns.get(i)).getSortOrder()) continue;
                                    SortOrder.invert(values[i], 0, values[i], 0, values[i].length);
                                }
                                projectedTable.newKey(ptr, (byte[][])values);
                                PRow row = projectedTable.newRow(this.kvBuilder, ts, ptr, (byte[][])new byte[0][]);
                                while (i < projectedColumns.size()) {
                                    Expression expression = selectExpressions.get(i);
                                    if (expression.evaluate(result, ptr)) {
                                        PColumn column = (PColumn)projectedColumns.get(i);
                                        Object value = expression.getDataType().toObject(ptr, column.getSortOrder());
                                        if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                                            throw new DataExceedsCapacityException(column.getDataType(), column.getMaxLength(), column.getScale());
                                        }
                                        column.getDataType().coerceBytes(ptr, value, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                                        byte[] bytes = ByteUtil.copyKeyBytesIfNecessary(ptr);
                                        row.setValue(column, bytes);
                                    }
                                    ++i;
                                }
                                for (Mutation mutation : row.toRowMutations()) {
                                    mutations.add(mutation);
                                }
                                for (i = 0; i < selectExpressions.size(); ++i) {
                                    selectExpressions.get(i).reset();
                                }
                            } else if (deleteCF != null && deleteCQ != null && (emptyCF == null || result.getValue(deleteCF, deleteCQ) != null)) {
                                Delete delete = new Delete(((Cell)results.get(0)).getRowArray(), ((Cell)results.get(0)).getRowOffset(), ((Cell)results.get(0)).getRowLength());
                                delete.deleteColumns(deleteCF, deleteCQ, ts);
                                mutations.add(delete);
                            }
                            if (emptyCF != null) {
                                HashSet timeStamps = Sets.newHashSetWithExpectedSize(results.size());
                                for (Cell kv : results) {
                                    long kvts = kv.getTimestamp();
                                    if (timeStamps.contains(kvts)) continue;
                                    Put put = new Put(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength());
                                    put.add(emptyCF, QueryConstants.EMPTY_COLUMN_BYTES, kvts, ByteUtil.EMPTY_BYTE_ARRAY);
                                    mutations.add(put);
                                }
                            }
                            if (!mutations.isEmpty() && batchSize > 0 && mutations.size() % batchSize == 0) {
                                UngroupedAggregateRegionObserver.commitBatch(region, mutations, indexUUID);
                                mutations.clear();
                            }
                            if (indexMutations.isEmpty() || batchSize <= 0 || indexMutations.size() % batchSize != 0) break block67;
                            UngroupedAggregateRegionObserver.commitBatch(region, indexMutations, null);
                            indexMutations.clear();
                        }
                        catch (ConstraintViolationException e) {
                            logger.error(LogUtil.addCustomAnnotations("Failed to create row in " + region.getRegionInfo().getRegionNameAsString() + " with values " + SchemaUtil.toString(values), ScanUtil.getCustomAnnotations(scan)), e);
                            continue;
                        }
                    }
                    ((Aggregators)aggregators).aggregate(rowAggregators, result);
                    hasAny = true;
                } while (hasMore);
            }
        }
        finally {
            block69: {
                try {
                    if (stats == null) break block69;
                    try {
                        stats.updateStatistic(region);
                    }
                    finally {
                        stats.close();
                    }
                }
                finally {
                    try {
                        innerScanner.close();
                    }
                    finally {
                        region.closeRegionOperation();
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(LogUtil.addCustomAnnotations("Finished scanning " + rowCount + " rows for ungrouped coprocessor scan " + scan, ScanUtil.getCustomAnnotations(scan)));
        }
        if (!mutations.isEmpty()) {
            UngroupedAggregateRegionObserver.commitBatch(region, mutations, indexUUID);
        }
        if (!indexMutations.isEmpty()) {
            UngroupedAggregateRegionObserver.commitBatch(region, indexMutations, null);
        }
        final boolean hadAny = hasAny;
        KeyValue keyValue = null;
        if (hadAny) {
            byte[] value = aggregators.toBytes(rowAggregators);
            keyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
        }
        final KeyValue aggKeyValue = keyValue;
        BaseRegionScanner scanner = new BaseRegionScanner(){
            private boolean done;
            {
                this.done = !hadAny;
            }

            @Override
            public HRegionInfo getRegionInfo() {
                return innerScanner.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() {
                return this.done;
            }

            @Override
            public void close() throws IOException {
                innerScanner.close();
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                if (this.done) {
                    return false;
                }
                this.done = true;
                results.add(aggKeyValue);
                return false;
            }

            @Override
            public long getMaxResultSize() {
                return scan.getMaxResultSize();
            }

            @Override
            public int getBatch() {
                return innerScanner.getBatch();
            }
        };
        return scanner;
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        InternalScanner internalScanner;
        block3: {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            internalScanner = scanner;
            if (scanType.equals((Object)ScanType.COMPACT_DROP_DELETES)) {
                try {
                    boolean useCurrentTime = c.getEnvironment().getConfiguration().getBoolean("phoenix.stats.useCurrentTime", true);
                    long clientTimeStamp = useCurrentTime ? TimeKeeper.SYSTEM.getCurrentTime() : -1L;
                    StatisticsCollector stats = new StatisticsCollector(c.getEnvironment(), table.getNameAsString(), clientTimeStamp, store.getFamily().getName());
                    internalScanner = stats.createCompactionScanner(c.getEnvironment().getRegion(), store, scanner);
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Unable to collect stats for " + table, e);
                }
            }
        }
        return internalScanner;
    }

    @Override
    public void postSplit(final ObserverContext<RegionCoprocessorEnvironment> e, final Region l, final Region r) throws IOException {
        block2: {
            final Region region = e.getEnvironment().getRegion();
            final TableName table = region.getRegionInfo().getTable();
            try {
                boolean useCurrentTime = e.getEnvironment().getConfiguration().getBoolean("phoenix.stats.useCurrentTime", true);
                final long clientTimeStamp = useCurrentTime ? TimeKeeper.SYSTEM.getCurrentTime() : -1L;
                User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        try (StatisticsCollector stats = new StatisticsCollector((RegionCoprocessorEnvironment)e.getEnvironment(), table.getNameAsString(), clientTimeStamp);){
                            stats.splitStats(region, l, r);
                            Void void_ = null;
                            return void_;
                        }
                    }
                });
            }
            catch (IOException ioe) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Error while collecting stats during split for " + table, ioe);
            }
        }
    }

    private static PTable deserializeTable(byte[] b) {
        try {
            PTableProtos.PTable ptableProto = PTableProtos.PTable.parseFrom(b);
            return PTableImpl.createFromProto(ptableProto);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Expression> deserializeExpressions(byte[] b) {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            int size = WritableUtils.readVInt(input);
            ArrayList<Expression> selectExpressions = Lists.newArrayListWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                ExpressionType type = ExpressionType.values()[WritableUtils.readVInt(input)];
                Expression selectExpression = type.newInstance();
                selectExpression.readFields(input);
                selectExpressions.add(selectExpression);
            }
            ArrayList<Expression> arrayList = selectExpressions;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] serialize(PTable projectedTable) {
        PTableProtos.PTable ptableProto = PTableImpl.toProto(projectedTable);
        return ptableProto.toByteArray();
    }

    public static byte[] serialize(List<Expression> selectExpressions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt(output, selectExpressions.size());
            for (int i = 0; i < selectExpressions.size(); ++i) {
                Expression expression = selectExpressions.get(i);
                WritableUtils.writeVInt(output, ExpressionType.valueOf(expression).ordinal());
                expression.write(output);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_UngroupedAgg") != null;
    }
}

