/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.CloneExpressionVisitor;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.util.SchemaUtil;

public class RowProjector {
    public static final RowProjector EMPTY_PROJECTOR = new RowProjector(Collections.emptyList(), 0, true);
    private final List<? extends ColumnProjector> columnProjectors;
    private final ListMultimap<String, Integer> reverseIndex;
    private final boolean allCaseSensitive;
    private final boolean someCaseSensitive;
    private final int estimatedSize;
    private final boolean isProjectEmptyKeyValue;
    private final boolean cloneRequired;
    private final boolean hasUDFs;

    public RowProjector(RowProjector projector, boolean isProjectEmptyKeyValue) {
        this(projector.getColumnProjectors(), projector.getEstimatedRowByteSize(), isProjectEmptyKeyValue, projector.hasUDFs);
    }

    public RowProjector(List<? extends ColumnProjector> columnProjectors, int estimatedRowSize, boolean isProjectEmptyKeyValue) {
        this(columnProjectors, estimatedRowSize, isProjectEmptyKeyValue, false);
    }

    public RowProjector(List<? extends ColumnProjector> columnProjectors, int estimatedRowSize, boolean isProjectEmptyKeyValue, boolean hasUDFs) {
        this.columnProjectors = Collections.unmodifiableList(columnProjectors);
        int position = columnProjectors.size();
        this.reverseIndex = ArrayListMultimap.create();
        boolean allCaseSensitive = true;
        boolean someCaseSensitive = false;
        --position;
        while (position >= 0) {
            ColumnProjector colProjector = columnProjectors.get(position);
            allCaseSensitive &= colProjector.isCaseSensitive();
            someCaseSensitive |= colProjector.isCaseSensitive();
            this.reverseIndex.put(colProjector.getName(), position);
            if (!colProjector.getTableName().isEmpty()) {
                this.reverseIndex.put(SchemaUtil.getColumnName(colProjector.getTableName(), colProjector.getName()), position);
            }
            --position;
        }
        this.allCaseSensitive = allCaseSensitive;
        this.someCaseSensitive = someCaseSensitive;
        this.estimatedSize = estimatedRowSize;
        this.isProjectEmptyKeyValue = isProjectEmptyKeyValue;
        this.hasUDFs = hasUDFs;
        boolean hasPerInvocationExpression = false;
        if (!hasUDFs) {
            for (int i = 0; i < this.columnProjectors.size(); ++i) {
                Expression expression = this.columnProjectors.get(i).getExpression();
                if (expression.getDeterminism() != Determinism.PER_INVOCATION) continue;
                hasPerInvocationExpression = true;
                break;
            }
        }
        this.cloneRequired = hasPerInvocationExpression || hasUDFs;
    }

    public RowProjector cloneIfNecessary() {
        if (!this.cloneRequired) {
            return this;
        }
        ArrayList<ColumnProjector> clonedColProjectors = new ArrayList<ColumnProjector>(this.columnProjectors.size());
        for (int i = 0; i < this.columnProjectors.size(); ++i) {
            ColumnProjector colProjector = this.columnProjectors.get(i);
            Expression expression = colProjector.getExpression();
            if (expression.getDeterminism() == Determinism.PER_INVOCATION) {
                CloneExpressionVisitor visitor = new CloneExpressionVisitor();
                Expression clonedExpression = expression.accept(visitor);
                clonedColProjectors.add(new ExpressionProjector(colProjector.getName(), colProjector.getTableName(), clonedExpression, colProjector.isCaseSensitive()));
                continue;
            }
            clonedColProjectors.add(colProjector);
        }
        return new RowProjector(clonedColProjectors, this.getEstimatedRowByteSize(), this.isProjectEmptyKeyValue(), this.hasUDFs);
    }

    public boolean isProjectEmptyKeyValue() {
        return this.isProjectEmptyKeyValue;
    }

    public List<? extends ColumnProjector> getColumnProjectors() {
        return this.columnProjectors;
    }

    public int getColumnIndex(String name) throws SQLException {
        List<Integer> index;
        if (!this.someCaseSensitive) {
            name = SchemaUtil.normalizeIdentifier(name);
        }
        if ((index = this.reverseIndex.get(name)).isEmpty()) {
            if (!this.allCaseSensitive && this.someCaseSensitive) {
                name = SchemaUtil.normalizeIdentifier(name);
                index = this.reverseIndex.get(name);
            }
            if (index.isEmpty()) {
                throw new ColumnNotFoundException(name);
            }
        }
        return index.get(0);
    }

    public ColumnProjector getColumnProjector(int index) {
        return this.columnProjectors.get(index);
    }

    public int getColumnCount() {
        return this.columnProjectors.size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (ColumnProjector columnProjector : this.columnProjectors) {
            buf.append(columnProjector.getExpression());
            buf.append(',');
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 1);
        }
        buf.append(']');
        return buf.toString();
    }

    public int getEstimatedRowByteSize() {
        return this.estimatedSize;
    }

    public void reset() {
        for (ColumnProjector columnProjector : this.columnProjectors) {
            columnProjector.getExpression().reset();
        }
    }
}

