/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.StringUtil;

public class PostIndexDDLCompiler {
    private final PhoenixConnection connection;
    private final TableRef dataTableRef;
    private List<String> indexColumnNames;
    private List<String> dataColumnNames;
    private String selectQuery;

    public PostIndexDDLCompiler(PhoenixConnection connection, TableRef dataTableRef) {
        this.connection = connection;
        this.dataTableRef = dataTableRef;
        this.indexColumnNames = Lists.newArrayList();
        this.dataColumnNames = Lists.newArrayList();
    }

    public MutationPlan compile(PTable indexTable) throws SQLException {
        int posOffset;
        StringBuilder indexColumns = new StringBuilder();
        StringBuilder dataColumns = new StringBuilder();
        List<PColumn> indexPKColumns = indexTable.getPKColumns();
        int nIndexPKColumns = indexTable.getPKColumns().size();
        boolean isSalted = indexTable.getBucketNum() != null;
        boolean isMultiTenant = this.connection.getTenantId() != null && indexTable.isMultiTenant();
        boolean isViewIndex = indexTable.getViewIndexId() != null;
        for (int i = posOffset = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isViewIndex ? 1 : 0); i < nIndexPKColumns; ++i) {
            PColumn col = indexPKColumns.get(i);
            String indexColName = col.getName().getString();
            String dataColName = StringUtil.escapeBackslash(col.getExpressionStr());
            dataColumns.append(dataColName).append(",");
            indexColumns.append('\"').append(indexColName).append("\",");
            this.indexColumnNames.add(indexColName);
            this.dataColumnNames.add(dataColName);
        }
        for (PColumnFamily family : indexTable.getColumnFamilies()) {
            for (PColumn col : family.getColumns()) {
                if (col.getViewConstant() != null) continue;
                String indexColName = col.getName().getString();
                String dataFamilyName = IndexUtil.getDataColumnFamilyName(indexColName);
                String dataColumnName = IndexUtil.getDataColumnName(indexColName);
                if (!dataFamilyName.equals("")) {
                    dataColumns.append('\"').append(dataFamilyName).append("\".");
                }
                dataColumns.append('\"').append(dataColumnName).append("\",");
                indexColumns.append('\"').append(indexColName).append("\",");
                this.indexColumnNames.add(indexColName);
                this.dataColumnNames.add(dataColumnName);
            }
        }
        dataColumns.setLength(dataColumns.length() - 1);
        indexColumns.setLength(indexColumns.length() - 1);
        String schemaName = this.dataTableRef.getTable().getSchemaName().getString();
        String tableName = indexTable.getTableName().getString();
        StringBuilder updateStmtStr = new StringBuilder();
        updateStmtStr.append("UPSERT /*+ NO_INDEX */ INTO ").append(schemaName.length() == 0 ? "" : '\"' + schemaName + "\".").append('\"').append(tableName).append("\"(").append((CharSequence)indexColumns).append(") ");
        StringBuilder selectQueryBuilder = new StringBuilder();
        selectQueryBuilder.append(" SELECT ").append((CharSequence)dataColumns).append(" FROM ").append(schemaName.length() == 0 ? "" : '\"' + schemaName + "\".").append('\"').append(this.dataTableRef.getTable().getTableName().getString()).append('\"');
        this.selectQuery = selectQueryBuilder.toString();
        updateStmtStr.append(this.selectQuery);
        try (PhoenixStatement statement = new PhoenixStatement(this.connection);){
            MutationPlan mutationPlan = statement.compileMutation(updateStmtStr.toString());
            return mutationPlan;
        }
    }

    public List<String> getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public List<String> getDataColumnNames() {
        return this.dataColumnNames;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }
}

