/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.StatelessTraverseNoExpressionVisitor;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;

public class OrderPreservingTracker {
    private final TrackOrderPreservingExpressionVisitor visitor;
    private final GroupByCompiler.GroupBy groupBy;
    private final Ordering ordering;
    private final int pkPositionOffset;
    private final List<Info> orderPreservingInfos;
    private boolean isOrderPreserving = true;
    private Boolean isReverse = null;

    public OrderPreservingTracker(StatementContext context, GroupByCompiler.GroupBy groupBy, Ordering ordering, int nNodes) {
        this(context, groupBy, ordering, nNodes, null);
    }

    public OrderPreservingTracker(StatementContext context, GroupByCompiler.GroupBy groupBy, Ordering ordering, int nNodes, TupleProjector projector) {
        int pkPositionOffset = 0;
        if (groupBy.isEmpty()) {
            PTable table = context.getResolver().getTables().get(0).getTable();
            boolean isSalted = table.getBucketNum() != null;
            boolean isMultiTenant = context.getConnection().getTenantId() != null && table.isMultiTenant();
            boolean isSharedViewIndex = table.getViewIndexId() != null;
            pkPositionOffset = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
        }
        this.pkPositionOffset = pkPositionOffset;
        this.groupBy = groupBy;
        this.visitor = new TrackOrderPreservingExpressionVisitor(projector);
        this.orderPreservingInfos = Lists.newArrayListWithExpectedSize(nNodes);
        this.ordering = ordering;
    }

    public void track(Expression node) {
        SortOrder sortOrder;
        this.track(node, sortOrder, (sortOrder = node.getSortOrder()) != SortOrder.getDefault());
    }

    public void track(Expression node, SortOrder sortOrder, boolean isNullsLast) {
        if (this.isOrderPreserving) {
            Info info = node.accept(this.visitor);
            if (info == null) {
                this.isOrderPreserving = false;
            } else {
                if (node.getSortOrder() != sortOrder) {
                    if (this.isReverse == null) {
                        this.isReverse = true;
                        if (!this.groupBy.isEmpty() && !this.groupBy.isOrderPreserving()) {
                            this.isOrderPreserving = false;
                            return;
                        }
                    } else if (!this.isReverse.booleanValue()) {
                        this.isOrderPreserving = false;
                        return;
                    }
                } else if (this.isReverse == null) {
                    this.isReverse = false;
                } else if (this.isReverse.booleanValue()) {
                    this.isOrderPreserving = false;
                    return;
                }
                if (node.isNullable() && !Boolean.valueOf(isNullsLast).equals(this.isReverse)) {
                    this.isOrderPreserving = false;
                    return;
                }
                this.orderPreservingInfos.add(info);
            }
        }
    }

    public boolean isOrderPreserving() {
        if (!this.isOrderPreserving) {
            return false;
        }
        if (this.ordering == Ordering.UNORDERED) {
            Collections.sort(this.orderPreservingInfos, new Comparator<Info>(){

                @Override
                public int compare(Info o1, Info o2) {
                    return o1.pkPosition - o2.pkPosition;
                }
            });
        }
        int prevSlotSpan = 1;
        int prevPos = this.pkPositionOffset - 1;
        FunctionExpression.OrderPreserving prevOrderPreserving = FunctionExpression.OrderPreserving.YES;
        for (int i = 0; i < this.orderPreservingInfos.size() && this.isOrderPreserving; ++i) {
            Info entry = this.orderPreservingInfos.get(i);
            int pos = entry.pkPosition;
            this.isOrderPreserving &= entry.orderPreserving != FunctionExpression.OrderPreserving.NO && (pos == prevPos || pos - prevSlotSpan == prevPos && prevOrderPreserving == FunctionExpression.OrderPreserving.YES);
            prevPos = pos;
            prevSlotSpan = entry.slotSpan;
            prevOrderPreserving = entry.orderPreserving;
        }
        return this.isOrderPreserving;
    }

    public boolean isReverse() {
        return Boolean.TRUE.equals(this.isReverse);
    }

    private static class TrackOrderPreservingExpressionVisitor
    extends StatelessTraverseNoExpressionVisitor<Info> {
        private final TupleProjector projector;

        public TrackOrderPreservingExpressionVisitor(TupleProjector projector) {
            this.projector = projector;
        }

        @Override
        public Info visit(RowKeyColumnExpression node) {
            return new Info(node.getPosition());
        }

        @Override
        public Info visit(ProjectedColumnExpression node) {
            if (this.projector == null) {
                return (Info)super.visit(node);
            }
            Expression expression = this.projector.getExpressions()[node.getPosition()];
            if (expression == node) {
                return (Info)super.visit(node);
            }
            return expression.accept(this);
        }

        @Override
        public Iterator<Expression> visitEnter(ScalarFunction node) {
            return node.preservesOrder() == FunctionExpression.OrderPreserving.NO ? Iterators.emptyIterator() : Iterators.singletonIterator(node.getChildren().get(node.getKeyFormationTraversalIndex()));
        }

        @Override
        public Info visitLeave(ScalarFunction node, List<Info> l) {
            if (l.isEmpty()) {
                return null;
            }
            Info info = l.get(0);
            FunctionExpression.OrderPreserving orderPreserving = FunctionExpression.OrderPreserving.values()[Math.min(node.preservesOrder().ordinal(), info.orderPreserving.ordinal())];
            if (orderPreserving == info.orderPreserving) {
                return info;
            }
            return new Info(info, orderPreserving);
        }

        @Override
        public Iterator<Expression> visitEnter(CoerceExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Info visitLeave(CoerceExpression node, List<Info> l) {
            if (l.isEmpty()) {
                return null;
            }
            return l.get(0);
        }

        @Override
        public Iterator<Expression> visitEnter(RowValueConstructorExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Info visitLeave(RowValueConstructorExpression node, List<Info> l) {
            Info firstInfo;
            if (l.size() != node.getChildren().size()) {
                return null;
            }
            Info lastInfo = firstInfo = l.get(0);
            for (int i = 1; i < l.size(); ++i) {
                if (lastInfo.orderPreserving == FunctionExpression.OrderPreserving.YES_IF_LAST) {
                    return null;
                }
                Info info = l.get(i);
                if (info.pkPosition != lastInfo.pkPosition + 1) {
                    return null;
                }
                lastInfo = info;
            }
            return new Info(firstInfo, l.size(), lastInfo.orderPreserving);
        }
    }

    public static class Info {
        public final FunctionExpression.OrderPreserving orderPreserving;
        public final int pkPosition;
        public final int slotSpan;

        public Info(int pkPosition) {
            this.pkPosition = pkPosition;
            this.orderPreserving = FunctionExpression.OrderPreserving.YES;
            this.slotSpan = 1;
        }

        public Info(Info info, FunctionExpression.OrderPreserving orderPreserving) {
            this.pkPosition = info.pkPosition;
            this.slotSpan = info.slotSpan;
            this.orderPreserving = orderPreserving;
        }

        public Info(Info info, int slotSpan, FunctionExpression.OrderPreserving orderPreserving) {
            this.pkPosition = info.pkPosition;
            this.slotSpan = slotSpan;
            this.orderPreserving = orderPreserving;
        }
    }

    public static enum Ordering {
        ORDERED,
        UNORDERED;

    }
}

