/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.iterate.ParallelIteratorFactory;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.KeyValueUtil;

public abstract class MutatingParallelIteratorFactory
implements ParallelIteratorFactory {
    protected final PhoenixConnection connection;

    protected MutatingParallelIteratorFactory(PhoenixConnection connection) {
        this.connection = connection;
    }

    protected abstract MutationState mutate(StatementContext var1, ResultIterator var2, PhoenixConnection var3) throws SQLException;

    @Override
    public PeekingResultIterator newIterator(StatementContext context, ResultIterator iterator, Scan scan) throws SQLException {
        final PhoenixConnection connection = new PhoenixConnection(this.connection);
        MutationState state = this.mutate(context, iterator, connection);
        long totalRowCount = state.getUpdateCount();
        if (connection.getAutoCommit()) {
            connection.getMutationState().join(state);
            connection.commit();
            ConnectionQueryServices services = connection.getQueryServices();
            int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
            state = new MutationState((long)maxSize, connection, totalRowCount);
        }
        final MutationState finalState = state;
        byte[] value = PLong.INSTANCE.toBytes(totalRowCount);
        KeyValue keyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
        final SingleKeyValueTuple tuple = new SingleKeyValueTuple(keyValue);
        return new PeekingResultIterator(){
            private boolean done = false;

            @Override
            public Tuple next() throws SQLException {
                if (this.done) {
                    return null;
                }
                this.done = true;
                return tuple;
            }

            @Override
            public void explain(List<String> planSteps) {
            }

            @Override
            public void close() throws SQLException {
                try {
                    if (!connection.getAutoCommit()) {
                        MutatingParallelIteratorFactory.this.connection.getMutationState().join(finalState);
                    }
                }
                finally {
                    connection.close();
                }
            }

            @Override
            public Tuple peek() throws SQLException {
                return this.done ? null : tuple;
            }
        };
    }
}

