/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;

public class ExpressionProjector
implements ColumnProjector {
    private final String name;
    private final Expression expression;
    private final String tableName;
    private final boolean isCaseSensitive;

    public ExpressionProjector(String name, String tableName, Expression expression, boolean isCaseSensitive) {
        this.name = name;
        this.expression = expression;
        this.tableName = tableName;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final Object getValue(Tuple tuple, PDataType type, ImmutableBytesWritable ptr) throws SQLException {
        try {
            Expression expression = this.getExpression();
            if (!expression.evaluate(tuple, ptr)) {
                return null;
            }
            if (ptr.getLength() == 0) {
                return null;
            }
            return type.toObject(ptr, expression.getDataType(), expression.getSortOrder(), expression.getMaxLength(), expression.getScale());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }
}

