/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ScanUtil;

public class DeleteCompiler {
    private static ParseNodeFactory FACTORY = new ParseNodeFactory();
    private final PhoenixStatement statement;

    public DeleteCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutationState deleteRows(PhoenixStatement statement, TableRef targetTableRef, TableRef indexTableRef, ResultIterator iterator, RowProjector projector, TableRef sourceTableRef) throws SQLException {
        PTable table = targetTableRef.getTable();
        PhoenixConnection connection = statement.getConnection();
        PName tenantId = connection.getTenantId();
        byte[] tenantIdBytes = null;
        if (tenantId != null) {
            tenantId = ScanUtil.padTenantIdIfNecessary(table.getRowKeySchema(), table.getBucketNum() != null, tenantId);
            tenantIdBytes = tenantId.getBytes();
        }
        boolean isAutoCommit = connection.getAutoCommit();
        ConnectionQueryServices services = connection.getQueryServices();
        int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
        HashMap<ImmutableBytesPtr, MutationState.RowMutationState> mutations = Maps.newHashMapWithExpectedSize(batchSize);
        HashMap<ImmutableBytesPtr, MutationState.RowMutationState> indexMutations = null;
        if (indexTableRef != null) {
            indexMutations = Maps.newHashMapWithExpectedSize(batchSize);
        }
        try {
            MutationState indexState;
            List<PColumn> pkColumns = table.getPKColumns();
            boolean isMultiTenant = table.isMultiTenant() && tenantIdBytes != null;
            boolean isSharedViewIndex = table.getViewIndexId() != null;
            int offset = table.getBucketNum() == null ? 0 : 1;
            byte[][] values = new byte[pkColumns.size()][];
            if (isMultiTenant) {
                values[offset++] = tenantIdBytes;
            }
            if (isSharedViewIndex) {
                values[offset++] = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
            }
            PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, statement);
            int rowCount = 0;
            while (rs.next()) {
                ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                if (sourceTableRef.equals(targetTableRef)) {
                    rs.getCurrentRow().getKey(ptr);
                } else {
                    for (int i = offset; i < values.length; ++i) {
                        byte[] byteValue = rs.getBytes(i + 1 - offset);
                        if (pkColumns.get(i).getSortOrder() == SortOrder.DESC) {
                            byte[] tempByteValue = Arrays.copyOf(byteValue, byteValue.length);
                            byteValue = SortOrder.invert(byteValue, 0, tempByteValue, 0, byteValue.length);
                        }
                        values[i] = byteValue;
                    }
                    table.newKey(ptr, values);
                }
                mutations.put(ptr, new MutationState.RowMutationState(PRow.DELETE_MARKER, statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO));
                if (indexTableRef != null) {
                    ImmutableBytesPtr indexPtr = new ImmutableBytesPtr();
                    rs.getCurrentRow().getKey(indexPtr);
                    indexMutations.put(indexPtr, new MutationState.RowMutationState(PRow.DELETE_MARKER, statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO));
                }
                if (mutations.size() > maxSize) {
                    throw new IllegalArgumentException("MutationState size of " + mutations.size() + " is bigger than max allowed size of " + maxSize);
                }
                if (!isAutoCommit || ++rowCount % batchSize != 0) continue;
                MutationState state = new MutationState(targetTableRef, mutations, 0L, maxSize, connection);
                connection.getMutationState().join(state);
                if (indexTableRef != null) {
                    indexState = new MutationState(indexTableRef, indexMutations, 0L, maxSize, connection);
                    connection.getMutationState().join(indexState);
                }
                connection.commit();
                mutations.clear();
                if (indexMutations == null) continue;
                indexMutations.clear();
            }
            int nCommittedRows = rowCount / batchSize * batchSize;
            MutationState state = new MutationState(targetTableRef, mutations, nCommittedRows, maxSize, connection);
            if (indexTableRef != null) {
                indexState = new MutationState(indexTableRef, indexMutations, 0L, maxSize, connection);
                state.join(indexState);
            }
            MutationState mutationState = state;
            return mutationState;
        }
        finally {
            iterator.close();
        }
    }

    private Map<PTableKey, PTable> getNonDisabledImmutableIndexes(TableRef tableRef) {
        PTable table = tableRef.getTable();
        if (table.isImmutableRows() && !table.getIndexes().isEmpty()) {
            HashMap<PTableKey, PTable> nonDisabledIndexes = new HashMap<PTableKey, PTable>(table.getIndexes().size());
            for (PTable index : table.getIndexes()) {
                if (index.getIndexState() == PIndexState.DISABLE) continue;
                nonDisabledIndexes.put(index.getKey(), index);
            }
            return nonDisabledIndexes;
        }
        return Collections.emptyMap();
    }

    public MutationPlan compile(DeleteStatement delete) throws SQLException {
        ArrayList<QueryPlan> queryPlans;
        DeletingParallelIteratorFactory parallelIteratorFactory;
        TableRef tableRefToBe;
        final PhoenixConnection connection = this.statement.getConnection();
        boolean isAutoCommit = connection.getAutoCommit();
        final boolean hasLimit = delete.getLimit() != null;
        ConnectionQueryServices services = connection.getQueryServices();
        NamedTableNode tableNode = delete.getTable();
        String tableName = tableNode.getName().getTableName();
        String schemaName = tableNode.getName().getSchemaName();
        boolean retryOnce = !isAutoCommit;
        boolean noQueryReqd = false;
        boolean runOnServer = false;
        SelectStatement select = null;
        Map<Object, Object> immutableIndex = Collections.emptyMap();
        while (true) {
            try {
                ColumnResolver resolver = FromCompiler.getResolverForMutation(delete, connection);
                tableRefToBe = resolver.getTables().get(0);
                PTable table = tableRefToBe.getTable();
                if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
                    throw new ReadOnlyTableException(table.getSchemaName().getString(), table.getTableName().getString());
                }
                immutableIndex = this.getNonDisabledImmutableIndexes(tableRefToBe);
                boolean mayHaveImmutableIndexes = !immutableIndex.isEmpty();
                noQueryReqd = !hasLimit;
                runOnServer = isAutoCommit && noQueryReqd;
                HintNode hint = delete.getHint();
                if (runOnServer && !delete.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
                    hint = HintNode.create(hint, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
                }
                ArrayList<AliasedNode> aliasedNodes = Lists.newArrayListWithExpectedSize(table.getPKColumns().size());
                boolean isSalted = table.getBucketNum() != null;
                boolean isMultiTenant = connection.getTenantId() != null && table.isMultiTenant();
                boolean isSharedViewIndex = table.getViewIndexId() != null;
                for (int i = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0); i < table.getPKColumns().size(); ++i) {
                    PColumn column = table.getPKColumns().get(i);
                    aliasedNodes.add(FACTORY.aliasedNode(null, FACTORY.column(null, '\"' + column.getName().getString() + '\"', null)));
                }
                select = FACTORY.select(delete.getTable(), hint, false, aliasedNodes, delete.getWhere(), Collections.emptyList(), null, delete.getOrderBy(), delete.getLimit(), delete.getBindCount(), false, false, Collections.emptyList(), delete.getUdfParseNodes());
                SelectStatement transformedSelect = SubqueryRewriter.transform(select = StatementNormalizer.normalize(select, resolver), resolver, connection);
                if (transformedSelect != select) {
                    resolver = FromCompiler.getResolverForQuery(transformedSelect, connection);
                    select = StatementNormalizer.normalize(transformedSelect, resolver);
                }
                parallelIteratorFactory = hasLimit ? null : new DeletingParallelIteratorFactory(connection);
                QueryOptimizer optimizer = new QueryOptimizer(services);
                queryPlans = Lists.newArrayList(mayHaveImmutableIndexes ? optimizer.getApplicablePlans(this.statement, select, resolver, Collections.emptyList(), parallelIteratorFactory) : optimizer.getBestPlan(this.statement, select, resolver, Collections.emptyList(), parallelIteratorFactory));
                if (!mayHaveImmutableIndexes) break;
                table = connection.getMetaDataCache().getTable(new PTableKey(table.getTenantId(), table.getName().getString()));
                tableRefToBe.setTable(table);
                immutableIndex = this.getNonDisabledImmutableIndexes(tableRefToBe);
            }
            catch (MetaDataEntityNotFoundException e) {
                if (retryOnce) {
                    MetaDataProtocol.MetaDataMutationResult result;
                    retryOnce = false;
                    if ((result = new MetaDataClient(connection).updateCache(schemaName, tableName)).wasUpdated()) continue;
                }
                throw e;
            }
            break;
        }
        boolean hasImmutableIndexes = !immutableIndex.isEmpty();
        TableRef[] tableRefs = new TableRef[hasImmutableIndexes ? immutableIndex.size() : 1];
        if (hasImmutableIndexes) {
            int i = 0;
            Iterator plans = queryPlans.iterator();
            while (plans.hasNext()) {
                QueryPlan plan = (QueryPlan)plans.next();
                PTable table = plan.getTableRef().getTable();
                if (table.getType() == PTableType.INDEX) {
                    tableRefs[i++] = plan.getTableRef();
                    immutableIndex.remove(table.getKey());
                    continue;
                }
                plans.remove();
            }
            if (!immutableIndex.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_FILTER_ON_IMMUTABLE_ROWS).setSchemaName(tableRefToBe.getTable().getSchemaName().getString()).setTableName(tableRefToBe.getTable().getTableName().getString()).build().buildException();
            }
        }
        tableRefs[0] = tableRefToBe;
        ArrayList<MutationPlan> mutationPlans = Lists.newArrayListWithExpectedSize(tableRefs.length);
        for (int i = 0; i < tableRefs.length; ++i) {
            final TableRef tableRef = tableRefs[i];
            final QueryPlan plan = (QueryPlan)queryPlans.get(i);
            if (!plan.getTableRef().equals(tableRef) || !(plan instanceof BaseQueryPlan)) {
                runOnServer = false;
                noQueryReqd = false;
            }
            final int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
            final StatementContext context = plan.getContext();
            if (noQueryReqd && (!context.getScan().hasFilter() || context.getScan().getFilter() instanceof SkipScanFilter) && context.getScanRanges().isPointLookup()) {
                mutationPlans.add(new MutationPlan(){

                    @Override
                    public ParameterMetaData getParameterMetaData() {
                        return context.getBindManager().getParameterMetaData();
                    }

                    @Override
                    public MutationState execute() {
                        ScanRanges ranges = context.getScanRanges();
                        Iterator<KeyRange> iterator = ranges.getPointLookupKeyIterator();
                        HashMap<ImmutableBytesPtr, MutationState.RowMutationState> mutation = Maps.newHashMapWithExpectedSize(ranges.getPointLookupCount());
                        while (iterator.hasNext()) {
                            mutation.put(new ImmutableBytesPtr(iterator.next().getLowerRange()), new MutationState.RowMutationState(PRow.DELETE_MARKER, DeleteCompiler.this.statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO));
                        }
                        return new MutationState(tableRef, mutation, 0L, maxSize, connection);
                    }

                    @Override
                    public ExplainPlan getExplainPlan() throws SQLException {
                        return new ExplainPlan(Collections.singletonList("DELETE SINGLE ROW"));
                    }

                    @Override
                    public PhoenixConnection getConnection() {
                        return connection;
                    }

                    @Override
                    public StatementContext getContext() {
                        return context;
                    }
                });
                continue;
            }
            if (runOnServer) {
                Scan scan = context.getScan();
                scan.setAttribute("_DeleteAgg", QueryConstants.TRUE);
                SelectStatement aggSelect = SelectStatement.create(SelectStatement.COUNT_ONE, delete.getHint());
                final RowProjector projector = ProjectionCompiler.compile(context, aggSelect, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                final AggregatePlan aggPlan = new AggregatePlan(context, (FilterableStatement)select, tableRef, projector, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null);
                mutationPlans.add(new MutationPlan(){

                    @Override
                    public PhoenixConnection getConnection() {
                        return connection;
                    }

                    @Override
                    public ParameterMetaData getParameterMetaData() {
                        return context.getBindManager().getParameterMetaData();
                    }

                    @Override
                    public StatementContext getContext() {
                        return context;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public MutationState execute() throws SQLException {
                        ImmutableBytesWritable ptr = context.getTempPtr();
                        tableRef.getTable().getIndexMaintainers(ptr, context.getConnection());
                        try (ServerCacheClient.ServerCache cache = null;){
                            MutationState mutationState;
                            if (ptr.getLength() > 0) {
                                IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(connection, tableRef);
                                cache = client.addIndexMetadataCache(context.getScanRanges(), ptr);
                                byte[] uuidValue = cache.getId();
                                context.getScan().setAttribute("IdxUUID", uuidValue);
                            }
                            ResultIterator iterator = aggPlan.iterator();
                            try {
                                Tuple row = iterator.next();
                                final long mutationCount = (Long)projector.getColumnProjector(0).getValue(row, PLong.INSTANCE, ptr);
                                mutationState = new MutationState(maxSize, connection){

                                    @Override
                                    public long getUpdateCount() {
                                        return mutationCount;
                                    }
                                };
                            }
                            catch (Throwable throwable) {
                                iterator.close();
                                throw throwable;
                            }
                            iterator.close();
                            return mutationState;
                        }
                    }

                    @Override
                    public ExplainPlan getExplainPlan() throws SQLException {
                        List<String> queryPlanSteps = aggPlan.getExplainPlan().getPlanSteps();
                        ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                        planSteps.add("DELETE ROWS");
                        planSteps.addAll(queryPlanSteps);
                        return new ExplainPlan(planSteps);
                    }
                });
                continue;
            }
            final boolean deleteFromImmutableIndexToo = hasImmutableIndexes && !plan.getTableRef().equals(tableRef);
            final DeletingParallelIteratorFactory parallelIteratorFactory2 = parallelIteratorFactory;
            mutationPlans.add(new MutationPlan(){

                @Override
                public PhoenixConnection getConnection() {
                    return connection;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return context.getBindManager().getParameterMetaData();
                }

                @Override
                public StatementContext getContext() {
                    return context;
                }

                @Override
                public MutationState execute() throws SQLException {
                    ResultIterator iterator = plan.iterator();
                    if (!hasLimit) {
                        Tuple tuple;
                        long totalRowCount = 0L;
                        if (parallelIteratorFactory2 != null) {
                            parallelIteratorFactory2.setRowProjector(plan.getProjector());
                            parallelIteratorFactory2.setTargetTableRef(tableRef);
                            parallelIteratorFactory2.setSourceTableRef(plan.getTableRef());
                            parallelIteratorFactory2.setIndexTargetTableRef(deleteFromImmutableIndexToo ? plan.getTableRef() : null);
                        }
                        while ((tuple = iterator.next()) != null) {
                            Cell kv = tuple.getValue(0);
                            totalRowCount += PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                        }
                        return new MutationState((long)maxSize, connection, totalRowCount);
                    }
                    return DeleteCompiler.deleteRows(DeleteCompiler.this.statement, tableRef, deleteFromImmutableIndexToo ? plan.getTableRef() : null, iterator, plan.getProjector(), plan.getTableRef());
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    List<String> queryPlanSteps = plan.getExplainPlan().getPlanSteps();
                    ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                    planSteps.add("DELETE ROWS");
                    planSteps.addAll(queryPlanSteps);
                    return new ExplainPlan(planSteps);
                }
            });
        }
        return mutationPlans.size() == 1 ? (MutationPlan)mutationPlans.get(0) : new MultiDeleteMutationPlan(mutationPlans);
    }

    private class MultiDeleteMutationPlan
    implements MutationPlan {
        private final List<MutationPlan> plans;
        private final MutationPlan firstPlan;

        public MultiDeleteMutationPlan(List<MutationPlan> plans) {
            Preconditions.checkArgument(!plans.isEmpty());
            this.plans = plans;
            this.firstPlan = plans.get(0);
        }

        @Override
        public StatementContext getContext() {
            return this.firstPlan.getContext();
        }

        @Override
        public ParameterMetaData getParameterMetaData() {
            return this.firstPlan.getParameterMetaData();
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return this.firstPlan.getExplainPlan();
        }

        @Override
        public PhoenixConnection getConnection() {
            return this.firstPlan.getConnection();
        }

        @Override
        public MutationState execute() throws SQLException {
            MutationState state = this.firstPlan.execute();
            for (MutationPlan plan : this.plans.subList(1, this.plans.size())) {
                plan.execute();
            }
            return state;
        }
    }

    private static class DeletingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private RowProjector projector;
        private TableRef targetTableRef;
        private TableRef indexTableRef;
        private TableRef sourceTableRef;

        private DeletingParallelIteratorFactory(PhoenixConnection connection) {
            super(connection);
        }

        @Override
        protected MutationState mutate(StatementContext context, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            PhoenixStatement statement = new PhoenixStatement(connection);
            return DeleteCompiler.deleteRows(statement, this.targetTableRef, this.indexTableRef, iterator, this.projector, this.sourceTableRef);
        }

        public void setTargetTableRef(TableRef tableRef) {
            this.targetTableRef = tableRef;
        }

        public void setSourceTableRef(TableRef tableRef) {
            this.sourceTableRef = tableRef;
        }

        public void setRowProjector(RowProjector projector) {
            this.projector = projector;
        }

        public void setIndexTargetTableRef(TableRef indexTableRef) {
            this.indexTableRef = indexTableRef;
        }
    }
}

