/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security.http;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    private static AbstractDelegationTokenSecretManager<?> manager;
    public static final String AUTH_HANDLER_PROPERTY = "yarn.resourcemanager.authentication-handler";
    private static final String OLD_HEADER = "Hadoop-YARN-Auth-Delegation-Token";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig.getServletContext().setAttribute("hadoop.http.delegation-token-secret-manager", manager);
        super.init(filterConfig);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String oldHeader;
        HttpServletRequest req = (HttpServletRequest)request;
        String newHeader = req.getHeader("X-Hadoop-Delegation-Token");
        if ((newHeader == null || newHeader.isEmpty()) && (oldHeader = req.getHeader(OLD_HEADER)) != null && !oldHeader.isEmpty()) {
            request = new HttpServletRequestWrapper(req){

                public String getHeader(String name) {
                    if (name.equals("X-Hadoop-Delegation-Token")) {
                        return oldHeader;
                    }
                    return super.getHeader(name);
                }
            };
        }
        super.doFilter((ServletRequest)request, response, filterChain);
    }

    public static void setDelegationTokenSecretManager(AbstractDelegationTokenSecretManager<?> manager) {
        RMAuthenticationFilter.manager = manager;
    }
}

