/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum SignalLogger {
    INSTANCE;

    private boolean registered = false;

    public void register(Log LOG) {
        if (this.registered) {
            throw new IllegalStateException("Can't re-install the signal handlers.");
        }
        this.registered = true;
        StringBuilder bld = new StringBuilder();
        bld.append("registered UNIX signal handlers for [");
        String[] SIGNALS = new String[]{"TERM", "HUP", "INT"};
        String separator = "";
        for (String signalName : SIGNALS) {
            try {
                new Handler(signalName, LOG);
                bld.append(separator);
                bld.append(signalName);
                separator = ", ";
            }
            catch (Exception e) {
                LOG.debug(e);
            }
        }
        bld.append("]");
        LOG.info(bld.toString());
    }

    private static class Handler
    implements SignalHandler {
        private final Log LOG;
        private final SignalHandler prevHandler;

        Handler(String name, Log LOG) {
            this.LOG = LOG;
            this.prevHandler = Signal.handle(new Signal(name), this);
        }

        @Override
        public void handle(Signal signal) {
            this.LOG.error("RECEIVED SIGNAL " + signal.getNumber() + ": SIG" + signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

