/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ServiceAuthorizationManager {
    static final String BLOCKED = ".blocked";
    private static final String HADOOP_POLICY_FILE = "hadoop-policy.xml";
    private volatile Map<Class<?>, AccessControlList[]> protocolToAcls = new IdentityHashMap();
    @Deprecated
    public static final String SERVICE_AUTHORIZATION_CONFIG = "hadoop.security.authorization";
    public static final Log AUDITLOG = LogFactory.getLog("SecurityLogger." + ServiceAuthorizationManager.class.getName());
    private static final String AUTHZ_SUCCESSFUL_FOR = "Authorization successful for ";
    private static final String AUTHZ_FAILED_FOR = "Authorization failed for ";

    public void authorize(UserGroupInformation user, Class<?> protocol, Configuration conf, InetAddress addr) throws AuthorizationException {
        String clientKey;
        AccessControlList[] acls = this.protocolToAcls.get(protocol);
        if (acls == null) {
            throw new AuthorizationException("Protocol " + protocol + " is not known.");
        }
        KerberosInfo krbInfo = SecurityUtil.getKerberosInfo(protocol, conf);
        String clientPrincipal = null;
        if (krbInfo != null && (clientKey = krbInfo.clientPrincipal()) != null && !clientKey.isEmpty()) {
            try {
                clientPrincipal = SecurityUtil.getServerPrincipal(conf.get(clientKey), addr);
            }
            catch (IOException e) {
                throw (AuthorizationException)new AuthorizationException("Can't figure out Kerberos principal name for connection from " + addr + " for user=" + user + " protocol=" + protocol).initCause(e);
            }
        }
        if (clientPrincipal != null && !clientPrincipal.equals(user.getUserName()) || acls.length != 2 || !acls[0].isUserAllowed(user) || acls[1].isUserAllowed(user)) {
            AUDITLOG.warn(AUTHZ_FAILED_FOR + user + " for protocol=" + protocol + ", expected client Kerberos principal is " + clientPrincipal);
            throw new AuthorizationException("User " + user + " is not authorized for protocol " + protocol + ", expected client Kerberos principal is " + clientPrincipal);
        }
        AUDITLOG.info(AUTHZ_SUCCESSFUL_FOR + user + " for protocol=" + protocol);
    }

    public void refresh(Configuration conf, PolicyProvider provider) {
        String policyFile = System.getProperty("hadoop.policy.file", HADOOP_POLICY_FILE);
        Configuration policyConf = new Configuration(conf);
        policyConf.addResource(policyFile);
        this.refreshWithLoadedConfiguration(policyConf, provider);
    }

    @InterfaceAudience.Private
    public void refreshWithLoadedConfiguration(Configuration conf, PolicyProvider provider) {
        IdentityHashMap newAcls = new IdentityHashMap();
        String defaultAcl = conf.get("security.service.authorization.default.acl", "*");
        String defaultBlockedAcl = conf.get("security.service.authorization.default.acl.blocked", "");
        Service[] services = provider.getServices();
        if (services != null) {
            for (Service service : services) {
                AccessControlList acl = new AccessControlList(conf.get(service.getServiceKey(), defaultAcl));
                AccessControlList blockedAcl = new AccessControlList(conf.get(service.getServiceKey() + BLOCKED, defaultBlockedAcl));
                newAcls.put(service.getProtocol(), new AccessControlList[]{acl, blockedAcl});
            }
        }
        this.protocolToAcls = newAcls;
    }

    @VisibleForTesting
    public Set<Class<?>> getProtocolsWithAcls() {
        return this.protocolToAcls.keySet();
    }

    @VisibleForTesting
    public AccessControlList getProtocolsAcls(Class<?> className) {
        return this.protocolToAcls.get(className)[0];
    }

    @VisibleForTesting
    public AccessControlList getProtocolsBlockedAcls(Class<?> className) {
        return this.protocolToAcls.get(className)[1];
    }
}

