/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.local;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class LocalContainerAllocator
extends RMCommunicator
implements ContainerAllocator {
    private static final Log LOG = LogFactory.getLog(LocalContainerAllocator.class);
    private final EventHandler eventHandler;
    private long retryInterval;
    private long retrystartTime;
    private String nmHost;
    private int nmPort;
    private int nmHttpPort;
    private ContainerId containerId;
    protected int lastResponseID;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public LocalContainerAllocator(ClientService clientService, AppContext context, String nmHost, int nmPort, int nmHttpPort, ContainerId cId) {
        super(clientService, context);
        this.eventHandler = context.getEventHandler();
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.containerId = cId;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.retrystartTime = System.currentTimeMillis();
    }

    @Override
    protected synchronized void heartbeat() throws Exception {
        AllocateRequest allocateRequest = AllocateRequest.newInstance(this.lastResponseID, super.getApplicationProgress(), new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>(), null);
        try {
            this.scheduler.allocate(allocateRequest);
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (ApplicationAttemptNotFoundException e) {
            LOG.info("Event from RM: shutting down Application Master");
            this.eventHandler.handle(new JobEvent(this.getJob().getID(), JobEventType.JOB_AM_REBOOT));
            throw new YarnRuntimeException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationID(), e);
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.info("ApplicationMaster is out of sync with ResourceManager, hence resync and send outstanding requests.");
            this.lastResponseID = 0;
            this.register();
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error("Could not contact RM after " + this.retryInterval + " milliseconds.");
                this.eventHandler.handle(new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
                throw new YarnRuntimeException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
    }

    @Override
    public void handle(ContainerAllocatorEvent event) {
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            LOG.info("Processing the event " + event.toString());
            ContainerId cID = ContainerId.newContainerId(this.getContext().getApplicationAttemptId(), this.containerId.getContainerId());
            Container container = this.recordFactory.newRecordInstance(Container.class);
            container.setId(cID);
            NodeId nodeId = NodeId.newInstance(this.nmHost, this.nmPort);
            container.setNodeId(nodeId);
            container.setContainerToken(null);
            container.setNodeHttpAddress(this.nmHost + ":" + this.nmHttpPort);
            if (event.getAttemptID().getTaskId().getTaskType() == TaskType.MAP) {
                JobCounterUpdateEvent jce = new JobCounterUpdateEvent(event.getAttemptID().getTaskId().getJobId());
                jce.addCounterUpdate(JobCounter.OTHER_LOCAL_MAPS, 1L);
                this.eventHandler.handle(jce);
            }
            this.eventHandler.handle(new TaskAttemptContainerAssignedEvent(event.getAttemptID(), container, this.applicationACLs));
        }
    }
}

