/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageHandler;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.string.StringEncoder;

public class WebImageViewer {
    public static final Log LOG = LogFactory.getLog(WebImageViewer.class);
    private Channel channel;
    private InetSocketAddress address;
    private final ChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), 1);
    private final ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
    static final ChannelGroup allChannels = new DefaultChannelGroup("WebImageViewer");

    public WebImageViewer(InetSocketAddress address) {
        this.address = address;
    }

    public void initServerAndWait(String fsimage) throws IOException {
        this.initServer(fsimage);
        try {
            this.channel.getCloseFuture().await();
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted. Stopping the WebImageViewer.");
            this.shutdown();
        }
    }

    @VisibleForTesting
    public void initServer(String fsimage) throws IOException {
        FSImageLoader loader = FSImageLoader.load(fsimage);
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("channelTracker", (ChannelHandler)new SimpleChannelUpstreamHandler(){

            public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                allChannels.add((Object)e.getChannel());
            }
        });
        pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("requestHandler", (ChannelHandler)new FSImageHandler(loader));
        pipeline.addLast("stringEncoder", (ChannelHandler)new StringEncoder());
        pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
        this.bootstrap.setPipeline(pipeline);
        this.channel = this.bootstrap.bind((SocketAddress)this.address);
        allChannels.add((Object)this.channel);
        this.address = (InetSocketAddress)this.channel.getLocalAddress();
        LOG.info("WebImageViewer started. Listening on " + this.address.toString() + ". Press Ctrl+C to stop the viewer.");
    }

    @VisibleForTesting
    public void shutdown() {
        allChannels.close().awaitUninterruptibly();
        this.factory.releaseExternalResources();
    }

    @VisibleForTesting
    public int getPort() {
        return this.address.getPort();
    }
}

