/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

public class FSImageHandler
extends SimpleChannelUpstreamHandler {
    public static final Log LOG = LogFactory.getLog(FSImageHandler.class);
    private final FSImageLoader loader;

    public FSImageHandler(FSImageLoader loader) throws IOException {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        String op = this.getOp(e);
        try {
            String path = this.getPath(e);
            this.handleOperation(op, path, e);
        }
        catch (Exception ex) {
            this.notFoundResponse(e);
            LOG.warn(ex.getMessage());
        }
        finally {
            e.getFuture().addListener(ChannelFutureListener.CLOSE);
        }
    }

    private String getOp(MessageEvent e) {
        Map parameters = this.getDecoder(e).getParameters();
        if (parameters.containsKey("op")) {
            return ((String)((List)parameters.get("op")).get(0)).toUpperCase();
        }
        return "";
    }

    private String getPath(MessageEvent e) throws FileNotFoundException {
        String path = this.getDecoder(e).getPath();
        if (path.startsWith("/webhdfs/v1/")) {
            return path.replaceFirst("/webhdfs/v1", "");
        }
        throw new FileNotFoundException("Path: " + path + " should " + "start with \"/webhdfs/v1/\"");
    }

    private QueryStringDecoder getDecoder(MessageEvent e) {
        HttpRequest request = (HttpRequest)e.getMessage();
        return new QueryStringDecoder(request.getUri());
    }

    private void handleOperation(String op, String path, MessageEvent e) throws IOException {
        HttpRequest request = (HttpRequest)e.getMessage();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setHeader("Content-Type", (Object)"application/json");
        String content = null;
        if (request.getMethod() == HttpMethod.GET) {
            if (op.equals("GETFILESTATUS")) {
                content = this.loader.getFileStatus(path);
            } else if (op.equals("LISTSTATUS")) {
                content = this.loader.listStatus(path);
            } else if (op.equals("GETACLSTATUS")) {
                content = this.loader.getAclStatus(path);
            } else {
                response.setStatus(HttpResponseStatus.BAD_REQUEST);
            }
        } else {
            response.setStatus(HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
        if (content != null) {
            HttpHeaders.setContentLength((HttpMessage)response, (long)content.length());
        }
        e.getChannel().write((Object)response);
        if (content != null) {
            e.getChannel().write((Object)content);
        }
        LOG.info(response.getStatus().getCode() + " method=" + request.getMethod().getName() + " op=" + op + " target=" + path);
    }

    private void notFoundResponse(MessageEvent e) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        e.getChannel().write((Object)response);
    }
}

