/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.primitives.Booleans;
import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;

class SegmentRecoveryComparator
implements Comparator<Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto>> {
    static final SegmentRecoveryComparator INSTANCE = new SegmentRecoveryComparator();

    SegmentRecoveryComparator() {
    }

    @Override
    public int compare(Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> a, Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> b) {
        QJournalProtocolProtos.PrepareRecoveryResponseProto r1 = a.getValue();
        QJournalProtocolProtos.PrepareRecoveryResponseProto r2 = b.getValue();
        if (r1.hasSegmentState() != r2.hasSegmentState()) {
            return Booleans.compare(r1.hasSegmentState(), r2.hasSegmentState());
        }
        if (!r1.hasSegmentState()) {
            return 0;
        }
        QJournalProtocolProtos.SegmentStateProto r1Seg = r1.getSegmentState();
        QJournalProtocolProtos.SegmentStateProto r2Seg = r2.getSegmentState();
        Preconditions.checkArgument(r1Seg.getStartTxId() == r2Seg.getStartTxId(), "Should only be called with responses for corresponding segments: %s and %s do not have the same start txid.", r1, r2);
        if (r1Seg.getIsInProgress() != r2Seg.getIsInProgress()) {
            return Booleans.compare(!r1Seg.getIsInProgress(), !r2Seg.getIsInProgress());
        }
        if (!r1Seg.getIsInProgress()) {
            if (r1Seg.getEndTxId() != r2Seg.getEndTxId()) {
                throw new AssertionError((Object)("finalized segs with different lengths: " + r1 + ", " + r2));
            }
            return 0;
        }
        long r1SeenEpoch = Math.max(r1.getAcceptedInEpoch(), r1.getLastWriterEpoch());
        long r2SeenEpoch = Math.max(r2.getAcceptedInEpoch(), r2.getLastWriterEpoch());
        return ComparisonChain.start().compare(r1SeenEpoch, r2SeenEpoch).compare(r1.getSegmentState().getEndTxId(), r2.getSegmentState().getEndTxId()).result();
    }
}

