/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSOutputStream;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsDataOutputStream
extends FSDataOutputStream {
    public HdfsDataOutputStream(DFSOutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super(out, stats, startPosition);
    }

    public HdfsDataOutputStream(DFSOutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        return ((DFSOutputStream)this.getWrappedStream()).getCurrentBlockReplication();
    }

    public void hsync(EnumSet<SyncFlag> syncFlags) throws IOException {
        ((DFSOutputStream)this.getWrappedStream()).hsync(syncFlags);
    }

    public static enum SyncFlag {
        UPDATE_LENGTH;

    }
}

