/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Classes;

@InterfaceAudience.Private
public class Methods {
    private static Log LOG = LogFactory.getLog(Methods.class);

    public static <T> Object call(Class<T> clazz, T instance, String methodName, Class[] types, Object[] args) throws Exception {
        try {
            Method m = clazz.getMethod(methodName, types);
            return m.invoke(instance, args);
        }
        catch (IllegalArgumentException arge) {
            LOG.fatal("Constructed invalid call. class=" + clazz.getName() + " method=" + methodName + " types=" + Classes.stringify(types), arge);
            throw arge;
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Can't find method " + methodName + " in " + clazz.getName() + "!", nsme);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() != null) {
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                if (ite.getTargetException() instanceof Error) {
                    throw (Error)ite.getTargetException();
                }
            }
            throw new UndeclaredThrowableException(ite, "Unknown exception invoking " + clazz.getName() + "." + methodName + "()");
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Denied access calling " + clazz.getName() + "." + methodName + "()", iae);
        }
        catch (SecurityException se) {
            LOG.fatal("SecurityException calling method. class=" + clazz.getName() + " method=" + methodName + " types=" + Classes.stringify(types), se);
            throw se;
        }
    }
}

