/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.OrderedNumeric;
import org.apache.hadoop.hbase.types.OrderedString;
import org.apache.hadoop.hbase.types.RawStringTerminated;
import org.apache.hadoop.hbase.types.Struct;
import org.apache.hadoop.hbase.types.StructBuilder;
import org.apache.hadoop.hbase.types.StructIterator;
import org.apache.hadoop.hbase.types.TerminatedWrapper;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestStructNullExtension {
    @Test(expected=NullPointerException.class)
    public void testNonNullableNullExtension() {
        Struct s = new StructBuilder().add(new RawStringTerminated("|")).toStruct();
        SimplePositionedMutableByteRange buf = new SimplePositionedMutableByteRange(4);
        s.encode((PositionedByteRange)buf, new Object[1]);
    }

    @Test
    public void testNullableNullExtension() {
        StructBuilder builder = new StructBuilder().add(OrderedNumeric.ASCENDING).add(OrderedString.ASCENDING);
        Struct shorter = builder.toStruct();
        Struct longer = builder.add(new TerminatedWrapper<String>(OrderedString.ASCENDING, "/")).add(OrderedNumeric.ASCENDING).toStruct();
        SimplePositionedMutableByteRange buf1 = new SimplePositionedMutableByteRange(7);
        Object[] val1 = new Object[]{BigDecimal.ONE, "foo"};
        Assert.assertEquals((String)"Encoding shorter value wrote a surprising number of bytes.", (long)buf1.getLength(), (long)shorter.encode((PositionedByteRange)buf1, val1));
        int shortLen = buf1.getLength();
        buf1.setPosition(0);
        StructIterator it = longer.iterator(buf1);
        it.skip();
        it.skip();
        Assert.assertEquals((String)"Position should be at end. Broken test.", (long)buf1.getLength(), (long)buf1.getPosition());
        Assert.assertEquals((String)"Failed to skip null element with extended struct.", (long)0L, (long)it.skip());
        Assert.assertEquals((String)"Failed to skip null element with extended struct.", (long)0L, (long)it.skip());
        buf1.setPosition(0);
        it = longer.iterator(buf1);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)it.next());
        Assert.assertEquals((Object)"foo", (Object)it.next());
        Assert.assertEquals((String)"Position should be at end. Broken test.", (long)buf1.getLength(), (long)buf1.getPosition());
        Assert.assertNull((String)"Failed to skip null element with extended struct.", (Object)it.next());
        Assert.assertNull((String)"Failed to skip null element with extended struct.", (Object)it.next());
        buf1.setPosition(0);
        Assert.assertArrayEquals((String)"Simple struct decoding is broken.", (Object[])val1, (Object[])shorter.decode(buf1));
        buf1.setPosition(0);
        Assert.assertArrayEquals((String)"Decoding short value with extended struct should append null elements.", (Object[])Arrays.copyOf(val1, 4), (Object[])longer.decode(buf1));
        SimplePositionedMutableByteRange buf2 = new SimplePositionedMutableByteRange(7);
        buf1.setPosition(0);
        Assert.assertEquals((String)"Encoding a short value with extended struct should have same result as using short struct.", (long)shortLen, (long)longer.encode((PositionedByteRange)buf2, val1));
        Assert.assertArrayEquals((String)"Encoding a short value with extended struct should have same result as using short struct", (byte[])buf1.getBytes(), (byte[])buf2.getBytes());
        val1 = new Object[]{null, null, null, null};
        buf1.set(0);
        buf2.set(0);
        Assert.assertEquals((String)"Encoding null-truncated value wrote a surprising number of bytes.", (long)buf1.getLength(), (long)longer.encode((PositionedByteRange)buf1, new Object[0]));
        Assert.assertEquals((String)"Encoding null-extended value wrote a surprising number of bytes.", (long)buf1.getLength(), (long)longer.encode((PositionedByteRange)buf1, val1));
        Assert.assertArrayEquals((String)"Encoded unexpected result.", (byte[])buf1.getBytes(), (byte[])buf2.getBytes());
        Assert.assertArrayEquals((String)"Decoded unexpected result.", (Object[])val1, (Object[])longer.decode(buf2));
        Object[] val2 = new Object[]{BigDecimal.ONE, null, null, null};
        buf1.set(2);
        buf2.set(2);
        Assert.assertEquals((String)"Encoding null-truncated value wrote a surprising number of bytes.", (long)buf1.getLength(), (long)longer.encode((PositionedByteRange)buf1, Arrays.copyOf(val2, 1)));
        Assert.assertEquals((String)"Encoding null-extended value wrote a surprising number of bytes.", (long)buf2.getLength(), (long)longer.encode((PositionedByteRange)buf2, val2));
        Assert.assertArrayEquals((String)"Encoded unexpected result.", (byte[])buf1.getBytes(), (byte[])buf2.getBytes());
        buf2.setPosition(0);
        Assert.assertArrayEquals((String)"Decoded unexpected result.", (Object[])val2, (Object[])longer.decode(buf2));
        Object[] val3 = new Object[]{BigDecimal.ONE, null, "foo", null};
        buf1.set(9);
        buf2.set(9);
        Assert.assertEquals((String)"Encoding null-truncated value wrote a surprising number of bytes.", (long)buf1.getLength(), (long)longer.encode((PositionedByteRange)buf1, Arrays.copyOf(val3, 3)));
        Assert.assertEquals((String)"Encoding null-extended value wrote a surprising number of bytes.", (long)buf2.getLength(), (long)longer.encode((PositionedByteRange)buf2, val3));
        Assert.assertArrayEquals((String)"Encoded unexpected result.", (byte[])buf1.getBytes(), (byte[])buf2.getBytes());
        buf2.setPosition(0);
        Assert.assertArrayEquals((String)"Decoded unexpected result.", (Object[])val3, (Object[])longer.decode(buf2));
    }
}

