/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.snapshot;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FlushSnapshotSubprocedure
extends Subprocedure {
    private static final Log LOG = LogFactory.getLog(FlushSnapshotSubprocedure.class);
    private final List<Region> regions;
    private final HBaseProtos.SnapshotDescription snapshot;
    private final RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager;
    private boolean snapshotSkipFlush = false;

    public FlushSnapshotSubprocedure(ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, List<Region> regions, HBaseProtos.SnapshotDescription snapshot, RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager) {
        super(member, snapshot.getName(), errorListener, wakeFrequency, timeout);
        this.snapshot = snapshot;
        if (this.snapshot.getType() == HBaseProtos.SnapshotDescription.Type.SKIPFLUSH) {
            this.snapshotSkipFlush = true;
        }
        this.regions = regions;
        this.taskManager = taskManager;
    }

    private void flushSnapshot() throws ForeignException {
        if (this.regions.isEmpty()) {
            return;
        }
        this.monitor.rethrowException();
        if (this.taskManager.hasTasks()) {
            throw new IllegalStateException("Attempting to take snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " but we currently have outstanding tasks");
        }
        for (Region region : this.regions) {
            this.taskManager.submitTask(new RegionSnapshotTask(region));
            this.monitor.rethrowException();
        }
        LOG.debug("Flush Snapshot Tasks submitted for " + this.regions.size() + " regions");
        try {
            this.taskManager.waitForOutstandingTasks();
        }
        catch (InterruptedException e) {
            throw new ForeignException(this.getMemberName(), e);
        }
    }

    @Override
    public void acquireBarrier() throws ForeignException {
    }

    @Override
    public byte[] insideBarrier() throws ForeignException {
        this.flushSnapshot();
        return new byte[0];
    }

    @Override
    public void cleanup(Exception e) {
        LOG.info("Aborting all online FLUSH snapshot subprocedure task threads for '" + this.snapshot.getName() + "' due to error", e);
        try {
            this.taskManager.cancelTasks();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseBarrier() {
    }

    private class RegionSnapshotTask
    implements Callable<Void> {
        Region region;

        RegionSnapshotTask(Region region) {
            this.region = region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LOG.debug("Starting region operation on " + this.region);
            this.region.startRegionOperation();
            try {
                if (FlushSnapshotSubprocedure.this.snapshotSkipFlush) {
                    LOG.debug("take snapshot without flush memstore first");
                } else {
                    LOG.debug("Flush Snapshotting region " + this.region.toString() + " started...");
                    this.region.flush(true);
                }
                ((HRegion)this.region).addRegionToSnapshot(FlushSnapshotSubprocedure.this.snapshot, FlushSnapshotSubprocedure.this.monitor);
                if (FlushSnapshotSubprocedure.this.snapshotSkipFlush) {
                    LOG.debug("... SkipFlush Snapshotting region " + this.region.toString() + " completed.");
                } else {
                    LOG.debug("... Flush Snapshotting region " + this.region.toString() + " completed.");
                }
            }
            finally {
                LOG.debug("Closing region operation on " + this.region);
                this.region.closeRegionOperation();
            }
            return null;
        }
    }
}

