/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.MetaMutationAnnotation;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class RegionServerCoprocessorHost
extends CoprocessorHost<RegionServerEnvironment> {
    private static final Log LOG = LogFactory.getLog(RegionServerCoprocessorHost.class);
    private RegionServerServices rsServices;

    public RegionServerCoprocessorHost(RegionServerServices rsServices, Configuration conf) {
        super(rsServices);
        this.rsServices = rsServices;
        this.conf = conf;
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        boolean tableCoprocessorsEnabled = conf.getBoolean("hbase.coprocessor.user.enabled", true);
        LOG.info("System coprocessor loading is " + (coprocessorsEnabled ? "enabled" : "disabled"));
        LOG.info("Table coprocessor loading is " + (coprocessorsEnabled && tableCoprocessorsEnabled ? "enabled" : "disabled"));
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.regionserver.classes");
    }

    @Override
    public RegionServerEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int sequence, Configuration conf) {
        return new RegionServerEnvironment(implClass, instance, priority, sequence, conf, this.rsServices);
    }

    public void preStop(String message) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.preStopRegionServer(ctx);
            }

            @Override
            public void postEnvCall(RegionServerEnvironment env) {
                RegionServerCoprocessorHost.this.shutdown(env);
            }
        });
    }

    public boolean preMerge(final HRegion regionA, final HRegion regionB) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMerge(ctx, regionA, regionB);
            }
        });
    }

    public void postMerge(final HRegion regionA, final HRegion regionB, final HRegion mergedRegion) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.postMerge(ctx, regionA, regionB, mergedRegion);
            }
        });
    }

    public boolean preMergeCommit(final HRegion regionA, final HRegion regionB, final @MetaMutationAnnotation List<Mutation> metaEntries) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.preMergeCommit(ctx, regionA, regionB, metaEntries);
            }
        });
    }

    public void postMergeCommit(final HRegion regionA, final HRegion regionB, final HRegion mergedRegion) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.postMergeCommit(ctx, regionA, regionB, mergedRegion);
            }
        });
    }

    public void preRollBackMerge(final HRegion regionA, final HRegion regionB) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.preRollBackMerge(ctx, regionA, regionB);
            }
        });
    }

    public void postRollBackMerge(final HRegion regionA, final HRegion regionB) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRollBackMerge(ctx, regionA, regionB);
            }
        });
    }

    public void preRollWALWriterRequest() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.preRollWALWriterRequest(ctx);
            }
        });
    }

    public void postRollWALWriterRequest() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRollWALWriterRequest(ctx);
            }
        });
    }

    public void preReplicateLogEntries(final List<AdminProtos.WALEntry> entries, final CellScanner cells) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.preReplicateLogEntries(ctx, entries, cells);
            }
        });
    }

    public void postReplicateLogEntries(final List<AdminProtos.WALEntry> entries, final CellScanner cells) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new CoprocessorOperation(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                oserver.postReplicateLogEntries(ctx, entries, cells);
            }
        });
    }

    public ReplicationEndpoint postCreateReplicationEndPoint(ReplicationEndpoint endpoint) throws IOException {
        return this.execOperationWithResult(endpoint, this.coprocessors.isEmpty() ? null : new CoprocessOperationWithResult<ReplicationEndpoint>(){

            @Override
            public void call(RegionServerObserver oserver, ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postCreateReplicationEndPoint(ctx, (ReplicationEndpoint)this.getResult()));
            }
        });
    }

    private <T> T execOperationWithResult(T defaultValue, CoprocessOperationWithResult<T> ctx) throws IOException {
        if (ctx == null) {
            return defaultValue;
        }
        ctx.setResult(defaultValue);
        this.execOperation(ctx);
        return ctx.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOperation(CoprocessorOperation ctx) throws IOException {
        if (ctx == null) {
            return false;
        }
        boolean bypass = false;
        for (RegionServerEnvironment env : this.coprocessors) {
            if (env.getInstance() instanceof RegionServerObserver) {
                ctx.prepare(env);
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(env.getClassLoader());
                    ctx.call((RegionServerObserver)env.getInstance(), ctx);
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowable(env, e);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
                bypass |= ctx.shouldBypass();
                if (ctx.shouldComplete()) break;
            }
            ctx.postEnvCall(env);
        }
        return bypass;
    }

    static class EnvironmentPriorityComparator
    implements Comparator<CoprocessorEnvironment> {
        EnvironmentPriorityComparator() {
        }

        @Override
        public int compare(CoprocessorEnvironment env1, CoprocessorEnvironment env2) {
            if (env1.getPriority() < env2.getPriority()) {
                return -1;
            }
            if (env1.getPriority() > env2.getPriority()) {
                return 1;
            }
            if (env1.getLoadSequence() < env2.getLoadSequence()) {
                return -1;
            }
            if (env1.getLoadSequence() > env2.getLoadSequence()) {
                return 1;
            }
            return 0;
        }
    }

    static class RegionServerEnvironment
    extends CoprocessorHost.Environment
    implements RegionServerCoprocessorEnvironment {
        private RegionServerServices regionServerServices;

        public RegionServerEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf);
            this.regionServerServices = services;
            for (Class<?> c : implClass.getInterfaces()) {
                if (!SingletonCoprocessorService.class.isAssignableFrom(c)) continue;
                this.regionServerServices.registerService(((SingletonCoprocessorService)((Object)impl)).getService());
                break;
            }
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.regionServerServices;
        }
    }

    private static abstract class CoprocessOperationWithResult<T>
    extends CoprocessorOperation {
        private T result = null;

        private CoprocessOperationWithResult() {
        }

        public void setResult(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    private static abstract class CoprocessorOperation
    extends ObserverContext<RegionServerCoprocessorEnvironment> {
        public abstract void call(RegionServerObserver var1, ObserverContext<RegionServerCoprocessorEnvironment> var2) throws IOException;

        public void postEnvCall(RegionServerEnvironment env) {
        }
    }
}

