/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class TimeBasedLimiter
implements QuotaLimiter {
    private long writeLastTs = 0L;
    private long readLastTs = 0L;
    private RateLimiter reqsLimiter = new RateLimiter();
    private RateLimiter reqSizeLimiter = new RateLimiter();
    private RateLimiter writeReqsLimiter = new RateLimiter();
    private RateLimiter writeSizeLimiter = new RateLimiter();
    private RateLimiter readReqsLimiter = new RateLimiter();
    private RateLimiter readSizeLimiter = new RateLimiter();
    private OperationQuota.AvgOperationSize avgOpSize = new OperationQuota.AvgOperationSize();

    private TimeBasedLimiter() {
    }

    static QuotaLimiter fromThrottle(QuotaProtos.Throttle throttle) {
        TimeBasedLimiter limiter = new TimeBasedLimiter();
        boolean isBypass = true;
        if (throttle.hasReqNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqsLimiter, throttle.getReqNum());
            isBypass = false;
        }
        if (throttle.hasReqSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.reqSizeLimiter, throttle.getReqSize());
            isBypass = false;
        }
        if (throttle.hasWriteNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeReqsLimiter, throttle.getWriteNum());
            isBypass = false;
        }
        if (throttle.hasWriteSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.writeSizeLimiter, throttle.getWriteSize());
            isBypass = false;
        }
        if (throttle.hasReadNum()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readReqsLimiter, throttle.getReadNum());
            isBypass = false;
        }
        if (throttle.hasReadSize()) {
            TimeBasedLimiter.setFromTimedQuota(limiter.readSizeLimiter, throttle.getReadSize());
            isBypass = false;
        }
        return isBypass ? NoopQuotaLimiter.get() : limiter;
    }

    public void update(TimeBasedLimiter other) {
        this.reqsLimiter.update(other.reqsLimiter);
        this.reqSizeLimiter.update(other.reqSizeLimiter);
        this.writeReqsLimiter.update(other.writeReqsLimiter);
        this.writeSizeLimiter.update(other.writeSizeLimiter);
        this.readReqsLimiter.update(other.readReqsLimiter);
        this.readSizeLimiter.update(other.readSizeLimiter);
    }

    private static void setFromTimedQuota(RateLimiter limiter, QuotaProtos.TimedQuota timedQuota) {
        limiter.set(timedQuota.getSoftLimit(), ProtobufUtil.toTimeUnit(timedQuota.getTimeUnit()));
    }

    @Override
    public void checkQuota(long writeSize, long readSize) throws ThrottlingException {
        long lastTs;
        long now = EnvironmentEdgeManager.currentTime();
        if (!this.reqsLimiter.canExecute(now, lastTs = Math.max(this.readLastTs, this.writeLastTs))) {
            ThrottlingException.throwNumRequestsExceeded(this.reqsLimiter.waitInterval());
        }
        if (!this.reqSizeLimiter.canExecute(now, lastTs, writeSize + readSize)) {
            ThrottlingException.throwNumRequestsExceeded(this.reqSizeLimiter.waitInterval(writeSize + readSize));
        }
        if (writeSize > 0L) {
            if (!this.writeReqsLimiter.canExecute(now, this.writeLastTs)) {
                ThrottlingException.throwNumWriteRequestsExceeded(this.writeReqsLimiter.waitInterval());
            }
            if (!this.writeSizeLimiter.canExecute(now, this.writeLastTs, writeSize)) {
                ThrottlingException.throwWriteSizeExceeded(this.writeSizeLimiter.waitInterval(writeSize));
            }
        }
        if (readSize > 0L) {
            if (!this.readReqsLimiter.canExecute(now, this.readLastTs)) {
                ThrottlingException.throwNumReadRequestsExceeded(this.readReqsLimiter.waitInterval());
            }
            if (!this.readSizeLimiter.canExecute(now, this.readLastTs, readSize)) {
                ThrottlingException.throwReadSizeExceeded(this.readSizeLimiter.waitInterval(readSize));
            }
        }
    }

    @Override
    public void grabQuota(long writeSize, long readSize) {
        assert (writeSize != 0L || readSize != 0L);
        long now = EnvironmentEdgeManager.currentTime();
        this.reqsLimiter.consume(1L);
        this.reqSizeLimiter.consume(writeSize + readSize);
        if (writeSize > 0L) {
            this.writeReqsLimiter.consume(1L);
            this.writeSizeLimiter.consume(writeSize);
            this.writeLastTs = now;
        }
        if (readSize > 0L) {
            this.readReqsLimiter.consume(1L);
            this.readSizeLimiter.consume(readSize);
            this.readLastTs = now;
        }
    }

    @Override
    public void consumeWrite(long size) {
        this.reqSizeLimiter.consume(size);
        this.writeSizeLimiter.consume(size);
    }

    @Override
    public void consumeRead(long size) {
        this.reqSizeLimiter.consume(size);
        this.readSizeLimiter.consume(size);
    }

    @Override
    public boolean isBypass() {
        return false;
    }

    @Override
    public long getWriteAvailable() {
        return this.writeSizeLimiter.getAvailable();
    }

    @Override
    public long getReadAvailable() {
        return this.readSizeLimiter.getAvailable();
    }

    @Override
    public void addOperationSize(OperationQuota.OperationType type, long size) {
        this.avgOpSize.addOperationSize(type, size);
    }

    @Override
    public long getAvgOperationSize(OperationQuota.OperationType type) {
        return this.avgOpSize.getAvgOperationSize(type);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeBasedLimiter(");
        if (!this.reqsLimiter.isBypass()) {
            builder.append("reqs=" + this.reqsLimiter);
        }
        if (!this.reqSizeLimiter.isBypass()) {
            builder.append(" resSize=" + this.reqSizeLimiter);
        }
        if (!this.writeReqsLimiter.isBypass()) {
            builder.append(" writeReqs=" + this.writeReqsLimiter);
        }
        if (!this.writeSizeLimiter.isBypass()) {
            builder.append(" writeSize=" + this.writeSizeLimiter);
        }
        if (!this.readReqsLimiter.isBypass()) {
            builder.append(" readReqs=" + this.readReqsLimiter);
        }
        if (!this.readSizeLimiter.isBypass()) {
            builder.append(" readSize=" + this.readSizeLimiter);
        }
        builder.append(')');
        return builder.toString();
    }
}

