/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.CorruptedWALProcedureStoreException;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureWALFormatReader {
    private static final Log LOG = LogFactory.getLog(ProcedureWALFormatReader.class);
    private final ProcedureStoreTracker tracker;
    private final Map<Long, Procedure> procedures = new HashMap<Long, Procedure>();
    private final Map<Long, ProcedureProtos.Procedure> localProcedures = new HashMap<Long, ProcedureProtos.Procedure>();
    private long maxProcId = 0L;

    public ProcedureWALFormatReader(ProcedureStoreTracker tracker) {
        this.tracker = tracker;
    }

    public void read(ProcedureWALFile log, ProcedureWALFormat.Loader loader) throws IOException {
        Object entry;
        FSDataInputStream stream = log.getStream();
        try {
            boolean hasMore = true;
            block9: while (hasMore) {
                entry = ProcedureWALFormat.readEntry(stream);
                if (entry == null) {
                    LOG.warn("nothing left to decode. exiting with missing EOF");
                    hasMore = false;
                    break;
                }
                switch (((ProcedureProtos.ProcedureWALEntry)entry).getType()) {
                    case INIT: {
                        this.readInitEntry((ProcedureProtos.ProcedureWALEntry)entry);
                        continue block9;
                    }
                    case INSERT: {
                        this.readInsertEntry((ProcedureProtos.ProcedureWALEntry)entry);
                        continue block9;
                    }
                    case UPDATE: 
                    case COMPACT: {
                        this.readUpdateEntry((ProcedureProtos.ProcedureWALEntry)entry);
                        continue block9;
                    }
                    case DELETE: {
                        this.readDeleteEntry((ProcedureProtos.ProcedureWALEntry)entry);
                        continue block9;
                    }
                    case EOF: {
                        hasMore = false;
                        continue block9;
                    }
                }
                throw new CorruptedWALProcedureStoreException("Invalid entry: " + entry);
            }
        }
        catch (IOException e) {
            LOG.error("got an exception while reading the procedure WAL: " + log, e);
            loader.markCorruptedWAL(log, e);
        }
        if (this.localProcedures.isEmpty()) {
            LOG.info("No active entry found in state log " + log + ". removing it");
            loader.removeLog(log);
        } else {
            Iterator<Map.Entry<Long, ProcedureProtos.Procedure>> itd = this.localProcedures.entrySet().iterator();
            while (itd.hasNext()) {
                entry = itd.next();
                itd.remove();
                Procedure proc = Procedure.convert((ProcedureProtos.Procedure)entry.getValue());
                this.procedures.put((Long)entry.getKey(), proc);
            }
        }
    }

    public Iterator<Procedure> getProcedures() {
        return this.procedures.values().iterator();
    }

    private void loadEntries(ProcedureProtos.ProcedureWALEntry entry) {
        for (ProcedureProtos.Procedure proc : entry.getProcedureList()) {
            this.maxProcId = Math.max(this.maxProcId, proc.getProcId());
            if (!this.isRequired(proc.getProcId())) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("read " + entry.getType() + " entry " + proc.getProcId());
            }
            this.localProcedures.put(proc.getProcId(), proc);
            this.tracker.setDeleted(proc.getProcId(), false);
        }
    }

    private void readInitEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
        this.loadEntries(entry);
    }

    private void readInsertEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() >= 1) : "Expected one or more procedures";
        this.loadEntries(entry);
    }

    private void readUpdateEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
        this.loadEntries(entry);
    }

    private void readDeleteEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() == 0) : "Expected no procedures";
        assert (entry.hasProcId()) : "expected ProcID";
        if (LOG.isTraceEnabled()) {
            LOG.trace("read delete entry " + entry.getProcId());
        }
        this.maxProcId = Math.max(this.maxProcId, entry.getProcId());
        this.localProcedures.remove(entry.getProcId());
        this.tracker.setDeleted(entry.getProcId(), true);
    }

    private boolean isDeleted(long procId) {
        return this.tracker.isDeleted(procId) == ProcedureStoreTracker.DeleteState.YES;
    }

    private boolean isRequired(long procId) {
        return !this.isDeleted(procId) && !this.procedures.containsKey(procId);
    }
}

