/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class MasterProcedureUtil {
    private static final Log LOG = LogFactory.getLog(MasterProcedureUtil.class);

    private MasterProcedureUtil() {
    }

    public static RPCProtos.UserInformation toProtoUserInfo(UserGroupInformation ugi) {
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        userInfoPB.setEffectiveUser(ugi.getUserName());
        if (ugi.getRealUser() != null) {
            userInfoPB.setRealUser(ugi.getRealUser().getUserName());
        }
        return userInfoPB.build();
    }

    public static UserGroupInformation toUserInfo(RPCProtos.UserInformation userInfoProto) {
        if (userInfoProto.hasEffectiveUser()) {
            String effectiveUser = userInfoProto.getEffectiveUser();
            if (userInfoProto.hasRealUser()) {
                String realUser = userInfoProto.getRealUser();
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(realUser);
                return UserGroupInformation.createProxyUser(effectiveUser, realUserUgi);
            }
            return UserGroupInformation.createRemoteUser(effectiveUser);
        }
        return null;
    }
}

