/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RowCounter {
    static final String NAME = "rowcounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        String startKey = null;
        String endKey = null;
        long startTime = 0L;
        long endTime = 0L;
        StringBuilder sb = new StringBuilder();
        String rangeSwitch = "--range=";
        String startTimeArgKey = "--starttime=";
        String endTimeArgKey = "--endtime=";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("--range=")) {
                String[] startEnd = args[i].substring("--range=".length()).split(",", 2);
                if (startEnd.length != 2 || startEnd[1].contains(",")) {
                    RowCounter.printUsage("Please specify range in such format as \"--range=a,b\" or, with only one boundary, \"--range=,b\" or \"--range=a,\"");
                    return null;
                }
                startKey = startEnd[0];
                endKey = startEnd[1];
            }
            if (startTime < endTime) {
                RowCounter.printUsage("--endtime=" + endTime + " needs to be greater than --starttime=" + startTime);
                return null;
            }
            if (args[i].startsWith("--starttime=")) {
                startTime = Long.parseLong(args[i].substring("--starttime=".length()));
                continue;
            }
            if (args[i].startsWith("--endtime=")) {
                endTime = Long.parseLong(args[i].substring("--endtime=".length()));
                continue;
            }
            sb.append(args[i]);
            sb.append(" ");
        }
        Job job = new Job(conf, "rowcounter_" + tableName);
        job.setJarByClass(RowCounter.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        TreeSet<byte[]> qualifiers = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        if (startKey != null && !startKey.equals("")) {
            scan.setStartRow(Bytes.toBytes(startKey));
        }
        if (endKey != null && !endKey.equals("")) {
            scan.setStopRow(Bytes.toBytes(endKey));
        }
        if (sb.length() > 0) {
            for (String columnName : sb.toString().trim().split(" ")) {
                String family = StringUtils.substringBefore(columnName, ":");
                String qualifier = StringUtils.substringAfter(columnName, ":");
                if (StringUtils.isBlank(qualifier)) {
                    scan.addFamily(Bytes.toBytes(family));
                    continue;
                }
                scan.addColumn(Bytes.toBytes(family), Bytes.toBytes(qualifier));
            }
        }
        if (qualifiers.size() == 0) {
            scan.setFilter(new FirstKeyOnlyFilter());
        } else {
            scan.setFilter(new FirstKeyValueMatchingQualifiersFilter(qualifiers));
        }
        scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        return job;
    }

    private static void printUsage(String errorMessage) {
        System.err.println("ERROR: " + errorMessage);
        RowCounter.printUsage();
    }

    private static void printUsage() {
        System.err.println("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey]] [<column1> <column2>...]");
        System.err.println("For performance consider the following options:\n-Dhbase.client.scanner.caching=100\n-Dmapreduce.map.speculative=false");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 1) {
            RowCounter.printUsage("Wrong number of parameters: " + args.length);
            System.exit(-1);
        }
        if ((job = RowCounter.createSubmittableJob(conf, otherArgs)) == null) {
            System.exit(-1);
        }
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        @Override
        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            context.getCounter(Counters.ROWS).increment(1L);
        }

        public static enum Counters {
            ROWS;

        }
    }
}

