/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyOnlyFilter
extends FilterBase {
    boolean lenAsVal;

    public KeyOnlyFilter() {
        this(false);
    }

    public KeyOnlyFilter(boolean lenAsVal) {
        this.lenAsVal = lenAsVal;
    }

    @Override
    public Cell transformCell(Cell cell) {
        return this.createKeyOnlyCell(cell);
    }

    private Cell createKeyOnlyCell(Cell c) {
        int dataLen = this.lenAsVal ? 4 : 0;
        int keyOffset = 8;
        int keyLen = KeyValueUtil.keyLength(c);
        byte[] newBuffer = new byte[keyLen + keyOffset + dataLen];
        Bytes.putInt(newBuffer, 0, keyLen);
        Bytes.putInt(newBuffer, 4, dataLen);
        KeyValueUtil.appendKeyTo(c, newBuffer, keyOffset);
        if (this.lenAsVal) {
            Bytes.putInt(newBuffer, newBuffer.length - dataLen, c.getValueLength());
        }
        return new KeyValue(newBuffer);
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 0 || filterArguments.size() == 1, "Expected: 0 or 1 but got: %s", filterArguments.size());
        KeyOnlyFilter filter = new KeyOnlyFilter();
        if (filterArguments.size() == 1) {
            filter.lenAsVal = ParseFilter.convertByteArrayToBoolean(filterArguments.get(0));
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.KeyOnlyFilter.Builder builder = FilterProtos.KeyOnlyFilter.newBuilder();
        builder.setLenAsVal(this.lenAsVal);
        return builder.build().toByteArray();
    }

    public static KeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.KeyOnlyFilter proto;
        try {
            proto = FilterProtos.KeyOnlyFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new KeyOnlyFilter(proto.getLenAsVal());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyOnlyFilter)) {
            return false;
        }
        KeyOnlyFilter other = (KeyOnlyFilter)o;
        return this.lenAsVal == other.lenAsVal;
    }
}

