/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class InclusiveStopFilter
extends FilterBase {
    private byte[] stopRowKey;
    private boolean done = false;

    public InclusiveStopFilter(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
    }

    public byte[] getStopRowKey() {
        return this.stopRowKey;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.done) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return this.stopRowKey == null;
        }
        int cmp = Bytes.compareTo(this.stopRowKey, 0, this.stopRowKey.length, buffer, offset, length);
        if (cmp < 0) {
            this.done = true;
        }
        return this.done;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        byte[] stopRowKey = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new InclusiveStopFilter(stopRowKey);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.InclusiveStopFilter.Builder builder = FilterProtos.InclusiveStopFilter.newBuilder();
        if (this.stopRowKey != null) {
            builder.setStopRowKey(ByteStringer.wrap(this.stopRowKey));
        }
        return builder.build().toByteArray();
    }

    public static InclusiveStopFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.InclusiveStopFilter proto;
        try {
            proto = FilterProtos.InclusiveStopFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new InclusiveStopFilter(proto.hasStopRowKey() ? proto.getStopRowKey().toByteArray() : null);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InclusiveStopFilter)) {
            return false;
        }
        InclusiveStopFilter other = (InclusiveStopFilter)o;
        return Bytes.equals(this.getStopRowKey(), other.getStopRowKey());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary(this.stopRowKey);
    }
}

