/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AclEntry {
    private final AclEntryType type;
    private final String name;
    private final FsAction permission;
    private final AclEntryScope scope;

    public AclEntryType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public FsAction getPermission() {
        return this.permission;
    }

    public AclEntryScope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AclEntry other = (AclEntry)o;
        return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal(this.name, other.name) && Objects.equal((Object)this.permission, (Object)other.permission) && Objects.equal((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.name, this.permission, this.scope});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.scope == AclEntryScope.DEFAULT) {
            sb.append("default:");
        }
        if (this.type != null) {
            sb.append(this.type.toString().toLowerCase());
        }
        sb.append(':');
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append(':');
        if (this.permission != null) {
            sb.append(this.permission.SYMBOL);
        }
        return sb.toString();
    }

    private AclEntry(AclEntryType type, String name, FsAction permission, AclEntryScope scope) {
        this.type = type;
        this.name = name;
        this.permission = permission;
        this.scope = scope;
    }

    public static List<AclEntry> parseAclSpec(String aclSpec, boolean includePermission) {
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        Collection<String> aclStrings = StringUtils.getStringCollection(aclSpec, ",");
        for (String aclStr : aclStrings) {
            AclEntry aclEntry = AclEntry.parseAclEntry(aclStr, includePermission);
            aclEntries.add(aclEntry);
        }
        return aclEntries;
    }

    public static AclEntry parseAclEntry(String aclStr, boolean includePermission) {
        Builder builder = new Builder();
        String[] split = aclStr.split(":");
        if (split.length == 0) {
            throw new HadoopIllegalArgumentException("Invalid <aclSpec> : " + aclStr);
        }
        int index = 0;
        if ("default".equals(split[0])) {
            ++index;
            builder.setScope(AclEntryScope.DEFAULT);
        }
        if (split.length <= index) {
            throw new HadoopIllegalArgumentException("Invalid <aclSpec> : " + aclStr);
        }
        AclEntryType aclType = null;
        try {
            aclType = Enum.valueOf(AclEntryType.class, split[index].toUpperCase());
            builder.setType(aclType);
        }
        catch (IllegalArgumentException iae) {
            throw new HadoopIllegalArgumentException("Invalid type of acl in <aclSpec> :" + aclStr);
        }
        if (split.length > ++index) {
            String name = split[index];
            if (!name.isEmpty()) {
                builder.setName(name);
            }
            ++index;
        }
        if (includePermission) {
            if (split.length <= index) {
                throw new HadoopIllegalArgumentException("Invalid <aclSpec> : " + aclStr);
            }
            String permission = split[index];
            FsAction fsAction = FsAction.getFsAction(permission);
            if (null == fsAction) {
                throw new HadoopIllegalArgumentException("Invalid permission in <aclSpec> : " + aclStr);
            }
            builder.setPermission(fsAction);
            ++index;
        }
        if (split.length > index) {
            throw new HadoopIllegalArgumentException("Invalid <aclSpec> : " + aclStr);
        }
        AclEntry aclEntry = builder.build();
        return aclEntry;
    }

    public static String aclSpecToString(List<AclEntry> aclSpec) {
        StringBuilder buf = new StringBuilder();
        for (AclEntry e : aclSpec) {
            buf.append(e.toString());
            buf.append(",");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public static class Builder {
        private AclEntryType type;
        private String name;
        private FsAction permission;
        private AclEntryScope scope = AclEntryScope.ACCESS;

        public Builder setType(AclEntryType type) {
            this.type = type;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPermission(FsAction permission) {
            this.permission = permission;
            return this;
        }

        public Builder setScope(AclEntryScope scope) {
            this.scope = scope;
            return this;
        }

        public AclEntry build() {
            return new AclEntry(this.type, this.name, this.permission, this.scope);
        }
    }
}

