/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ScanUtil {
    public static final int[] SINGLE_COLUMN_SLOT_SPAN = new int[1];
    private static final byte[] MAX_FILL_LENGTH_FOR_PREVIOUS_KEY = new byte[16];
    private static final byte[] ZERO_BYTE_ARRAY;

    private ScanUtil() {
    }

    public static void setTenantId(Scan scan, byte[] tenantId) {
        scan.setAttribute("TenantId", tenantId);
    }

    public static void setLocalIndex(Scan scan) {
        scan.setAttribute("_LocalIndex", PDataType.TRUE_BYTES);
    }

    public static boolean isLocalIndex(Scan scan) {
        return scan.getAttribute("_LocalIndex") != null;
    }

    public static ImmutableBytesWritable getTenantId(Scan scan) {
        byte[] tenantId = scan.getAttribute("TenantId");
        if (tenantId == null) {
            return null;
        }
        return new ImmutableBytesWritable(tenantId);
    }

    public static void setCustomAnnotations(Scan scan, byte[] annotations) {
        scan.setAttribute("_Annot", annotations);
    }

    public static byte[] getCustomAnnotations(Scan scan) {
        return scan.getAttribute("_Annot");
    }

    public static Scan newScan(Scan scan) {
        try {
            Scan newScan = new Scan(scan);
            TreeMap existingMap = (TreeMap)scan.getFamilyMap();
            TreeMap<byte[], NavigableSet<byte[]>> clonedMap = new TreeMap<byte[], NavigableSet<byte[]>>(existingMap);
            newScan.setFamilyMap(clonedMap);
            newScan.setReversed(scan.isReversed());
            newScan.setSmall(scan.isSmall());
            return newScan;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey) {
        return ScanUtil.intersectScanRange(scan, startKey, stopKey, false);
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey, boolean useSkipScan) {
        boolean mayHaveRows = false;
        int offset = 0;
        if (ScanUtil.isLocalIndex(scan)) {
            offset = startKey.length != 0 ? startKey.length : stopKey.length;
        }
        byte[] existingStartKey = scan.getStartRow();
        byte[] existingStopKey = scan.getStopRow();
        if (existingStartKey.length > 0) {
            if (startKey.length == 0 || Bytes.compareTo(existingStartKey, startKey) > 0) {
                startKey = existingStartKey;
            }
        } else {
            mayHaveRows = true;
        }
        if (existingStopKey.length > 0) {
            if (stopKey.length == 0 || Bytes.compareTo(existingStopKey, stopKey) < 0) {
                stopKey = existingStopKey;
            }
        } else {
            mayHaveRows = true;
        }
        scan.setStartRow(startKey);
        scan.setStopRow(stopKey);
        if (offset > 0 && useSkipScan) {
            byte[] temp = null;
            if (startKey.length != 0) {
                temp = new byte[startKey.length - offset];
                System.arraycopy(startKey, offset, temp, 0, startKey.length - offset);
                startKey = temp;
            }
            if (stopKey.length != 0) {
                temp = new byte[stopKey.length - offset];
                System.arraycopy(stopKey, offset, temp, 0, stopKey.length - offset);
                stopKey = temp;
            }
        }
        boolean bl = mayHaveRows = mayHaveRows || Bytes.compareTo(scan.getStartRow(), scan.getStopRow()) < 0;
        if (mayHaveRows && useSkipScan) {
            Filter filter = scan.getFilter();
            if (filter instanceof SkipScanFilter) {
                SkipScanFilter oldFilter = (SkipScanFilter)filter;
                SkipScanFilter newFilter = oldFilter.intersect(startKey, stopKey);
                if (newFilter == null) {
                    return false;
                }
                scan.setFilter(newFilter);
            } else if (filter instanceof FilterList) {
                FilterList oldList = (FilterList)filter;
                FilterList newList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                for (Filter f : oldList.getFilters()) {
                    if (f instanceof SkipScanFilter) {
                        SkipScanFilter newFilter = ((SkipScanFilter)f).intersect(startKey, stopKey);
                        if (newFilter == null) {
                            return false;
                        }
                        newList.addFilter(newFilter);
                        continue;
                    }
                    newList.addFilter(f);
                }
                scan.setFilter(newList);
            }
        }
        return mayHaveRows;
    }

    public static void andFilterAtBeginning(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.add(andWithFilter);
            allFilters.addAll(filterList.getFilters());
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(andWithFilter, filter)));
        }
    }

    public static void andFilterAtEnd(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.addAll(filterList.getFilters());
            allFilters.add(andWithFilter);
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filter, andWithFilter)));
        }
    }

    public static void setTimeRange(Scan scan, long ts) {
        ScanUtil.setTimeRange(scan, 0L, ts);
    }

    public static void setTimeRange(Scan scan, long minTS, long maxTS) {
        try {
            scan.setTimeRange(minTS, maxTS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setTimeRange(Scan scan, TimeRange range) {
        try {
            scan.setTimeRange(range.getMin(), range.getMax());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getMinKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan) {
        return ScanUtil.getKey(schema, slots, slotSpan, KeyRange.Bound.LOWER);
    }

    public static byte[] getMaxKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan) {
        return ScanUtil.getKey(schema, slots, slotSpan, KeyRange.Bound.UPPER);
    }

    private static byte[] getKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, KeyRange.Bound bound) {
        if (slots.isEmpty()) {
            return KeyRange.UNBOUND;
        }
        int[] position = new int[slots.size()];
        int maxLength = 0;
        for (int i = 0; i < position.length; ++i) {
            position[i] = bound == KeyRange.Bound.LOWER ? 0 : slots.get(i).size() - 1;
            KeyRange range = slots.get(i).get(position[i]);
            maxLength += range.getRange(bound).length + (schema.getField(i + slotSpan[i]).getDataType().isFixedWidth() ? 0 : 1);
        }
        byte[] key = new byte[maxLength];
        int length = ScanUtil.setKey(schema, slots, slotSpan, position, bound, key, 0, 0, position.length);
        if (length == 0) {
            return KeyRange.UNBOUND;
        }
        if (length == maxLength) {
            return key;
        }
        byte[] keyCopy = new byte[length];
        System.arraycopy(key, 0, keyCopy, 0, length);
        return keyCopy;
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex) {
        return ScanUtil.setKey(schema, slots, slotSpan, position, bound, key, byteOffset, slotStartIndex, slotEndIndex, slotStartIndex);
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex, int schemaStartIndex) {
        int offset = byteOffset;
        boolean lastInclusiveUpperSingleKey = false;
        boolean anyInclusiveUpperRangeKey = false;
        int i = slotStartIndex;
        int fieldIndex = ScanUtil.getRowKeyPosition(slotSpan, slotStartIndex);
        for (i = slotStartIndex; i < slotEndIndex; ++i) {
            KeyRange range = slots.get(i).get(position[i]);
            boolean isFixedWidth = schema.getField(fieldIndex + slotSpan[i]).getDataType().isFixedWidth();
            fieldIndex += slotSpan[i] + 1;
            if (range.isUnbound(bound) && (bound == KeyRange.Bound.UPPER || isFixedWidth)) break;
            byte[] bytes = range.getRange(bound);
            System.arraycopy(bytes, 0, key, offset, bytes.length);
            offset += bytes.length;
            boolean inclusiveUpper = range.isInclusive(bound) && bound == KeyRange.Bound.UPPER;
            boolean exclusiveLower = !range.isInclusive(bound) && bound == KeyRange.Bound.LOWER;
            lastInclusiveUpperSingleKey = range.isSingleKey() && inclusiveUpper;
            anyInclusiveUpperRangeKey |= !range.isSingleKey() && inclusiveUpper;
            if (!isFixedWidth && (fieldIndex < schema.getMaxFields() || inclusiveUpper || exclusiveLower)) {
                key[offset++] = 0;
                lastInclusiveUpperSingleKey &= i < schema.getMaxFields() - 1;
            }
            if (range.isSingleKey() || !exclusiveLower || ByteUtil.nextKey(key, offset)) continue;
            return -byteOffset;
        }
        if ((lastInclusiveUpperSingleKey || anyInclusiveUpperRangeKey) && !ByteUtil.nextKey(key, offset)) {
            return -byteOffset;
        }
        if (bound == KeyRange.Bound.LOWER) {
            while (--i >= schemaStartIndex && offset > byteOffset && !schema.getField(--fieldIndex).getDataType().isFixedWidth() && key[offset - 1] == 0) {
                --offset;
                fieldIndex -= slotSpan[i];
            }
        }
        return offset - byteOffset;
    }

    public static int searchClosestKeyRangeWithUpperHigherThanPtr(List<KeyRange> slots, ImmutableBytesWritable ptr, int lower) {
        int mid;
        int upper = slots.size() - 1;
        while (lower <= upper) {
            mid = (lower + upper) / 2;
            int cmp = slots.get(mid).compareUpperToLowerBound(ptr, true);
            if (cmp < 0) {
                lower = mid + 1;
                continue;
            }
            if (cmp > 0) {
                upper = mid - 1;
                continue;
            }
            return mid;
        }
        mid = (lower + upper) / 2;
        if (mid == 0 && slots.get(mid).compareUpperToLowerBound(ptr, true) > 0) {
            return mid;
        }
        return ++mid;
    }

    public static ScanRanges newScanRanges(List<Mutation> mutations) throws SQLException {
        ArrayList<KeyRange> keys = Lists.newArrayListWithExpectedSize(mutations.size());
        for (Mutation m : mutations) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(m.getRow()));
        }
        ScanRanges keyRanges = ScanRanges.create(SchemaUtil.VAR_BINARY_SCHEMA, Collections.singletonList(keys), SINGLE_COLUMN_SLOT_SPAN);
        return keyRanges;
    }

    public static KeyRange convertToInclusiveExclusiveRange(KeyRange partialRange, RowKeySchema schema, ImmutableBytesWritable ptr) {
        byte[] lowerRange = partialRange.getLowerRange();
        if (!partialRange.lowerUnbound() && !partialRange.isLowerInclusive()) {
            lowerRange = ScanUtil.nextKey(lowerRange, schema, ptr);
        }
        byte[] upperRange = partialRange.getUpperRange();
        if (!partialRange.upperUnbound() && partialRange.isUpperInclusive()) {
            upperRange = ScanUtil.nextKey(upperRange, schema, ptr);
        }
        if (partialRange.getLowerRange() != lowerRange || partialRange.getUpperRange() != upperRange) {
            partialRange = KeyRange.getKeyRange(lowerRange, upperRange);
        }
        return partialRange;
    }

    private static byte[] nextKey(byte[] key, RowKeySchema schema, ImmutableBytesWritable ptr) {
        int pos = 0;
        int maxOffset = schema.iterator(key, ptr);
        while (schema.next(ptr, pos, maxOffset) != null) {
            ++pos;
        }
        if (!schema.getField(pos - 1).getDataType().isFixedWidth()) {
            byte[] newLowerRange = new byte[key.length + 1];
            System.arraycopy(key, 0, newLowerRange, 0, key.length);
            newLowerRange[key.length] = 0;
            key = newLowerRange;
        } else {
            key = Arrays.copyOf(key, key.length);
        }
        ByteUtil.nextKey(key, key.length);
        return key;
    }

    public static boolean isReversed(Scan scan) {
        return scan.getAttribute("_ReverseScan") != null;
    }

    public static void setReversed(Scan scan) {
        scan.setAttribute("_ReverseScan", PDataType.TRUE_BYTES);
    }

    public static void setupReverseScan(Scan scan) {
        if (ScanUtil.isReversed(scan)) {
            byte[] startRow = scan.getStartRow();
            byte[] stopRow = scan.getStopRow();
            byte[] newStartRow = startRow;
            byte[] newStopRow = stopRow;
            if (startRow.length != 0) {
                newStartRow = Arrays.copyOf(startRow, startRow.length + MAX_FILL_LENGTH_FOR_PREVIOUS_KEY.length);
                if (ByteUtil.previousKey(newStartRow, startRow.length)) {
                    System.arraycopy(MAX_FILL_LENGTH_FOR_PREVIOUS_KEY, 0, newStartRow, startRow.length, MAX_FILL_LENGTH_FOR_PREVIOUS_KEY.length);
                } else {
                    newStartRow = HConstants.EMPTY_START_ROW;
                }
            }
            if (stopRow.length != 0) {
                newStopRow = ByteUtil.concat(stopRow, new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY});
            }
            scan.setStartRow(newStopRow);
            scan.setStopRow(newStartRow);
            scan.setReversed(true);
        }
    }

    public static int getRowKeyOffset(byte[] regionStartKey, byte[] regionEndKey) {
        return regionStartKey.length > 0 ? regionStartKey.length : regionEndKey.length;
    }

    private static void setRowKeyOffset(Filter filter, int offset) {
        if (filter instanceof BooleanExpressionFilter) {
            BooleanExpressionFilter boolFilter = (BooleanExpressionFilter)filter;
            IndexUtil.setRowKeyExpressionOffset(boolFilter.getExpression(), offset);
        } else if (filter instanceof SkipScanFilter) {
            SkipScanFilter skipScanFilter = (SkipScanFilter)filter;
            skipScanFilter.setOffset(offset);
        }
    }

    public static void setRowKeyOffset(Scan scan, int offset) {
        Filter filter = scan.getFilter();
        if (filter == null) {
            return;
        }
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            for (Filter childFilter : filterList.getFilters()) {
                ScanUtil.setRowKeyOffset(childFilter, offset);
            }
        } else {
            ScanUtil.setRowKeyOffset(filter, offset);
        }
    }

    public static int[] getDefaultSlotSpans(int nSlots) {
        return new int[nSlots];
    }

    public static int getTotalSpan(List<List<KeyRange>> ranges, int[] slotSpan) {
        return ScanUtil.getRowKeyPosition(slotSpan, ranges.size());
    }

    public static int getRowKeyPosition(int[] slotSpan, int slotPosition) {
        int offset = 0;
        for (int i = 0; i < slotPosition; ++i) {
            offset += slotSpan[i];
        }
        return offset + slotPosition;
    }

    public static boolean isAnalyzeTable(Scan scan) {
        return scan.getAttribute("_ANALYZETABLE") != null;
    }

    public static boolean crossesPrefixBoundary(byte[] key, byte[] prefixBytes, int prefixLength) {
        if (key.length < prefixLength) {
            return true;
        }
        if (prefixBytes.length >= prefixLength) {
            return Bytes.compareTo(prefixBytes, 0, prefixLength, key, 0, prefixLength) != 0;
        }
        return ScanUtil.hasNonZeroLeadingBytes(key, prefixLength);
    }

    public static byte[] getPrefix(byte[] startKey, int prefixLength) {
        return startKey.length >= prefixLength ? startKey : ByteUtil.EMPTY_BYTE_ARRAY;
    }

    private static boolean hasNonZeroLeadingBytes(byte[] key, int nBytesToCheck) {
        if (nBytesToCheck > ZERO_BYTE_ARRAY.length) {
            do {
                if (Bytes.compareTo(key, nBytesToCheck - ZERO_BYTE_ARRAY.length, ZERO_BYTE_ARRAY.length, ZERO_BYTE_ARRAY, 0, ZERO_BYTE_ARRAY.length) == 0) continue;
                return true;
            } while ((nBytesToCheck -= ZERO_BYTE_ARRAY.length) > ZERO_BYTE_ARRAY.length);
        }
        return Bytes.compareTo(key, 0, nBytesToCheck, ZERO_BYTE_ARRAY, 0, nBytesToCheck) != 0;
    }

    public static PName padTenantIdIfNecessary(RowKeySchema schema, boolean isSalted, PName tenantId) {
        int pkPos = isSalted ? 1 : 0;
        String tenantIdStr = tenantId.getString();
        ValueSchema.Field field = schema.getField(pkPos);
        PDataType dataType = field.getDataType();
        boolean isFixedWidth = dataType.isFixedWidth();
        Integer maxLength = field.getMaxLength();
        if (isFixedWidth && maxLength != null && tenantIdStr.length() < maxLength) {
            tenantIdStr = (String)dataType.pad(tenantIdStr, maxLength);
            return PNameFactory.newName(tenantIdStr);
        }
        return tenantId;
    }

    public static Iterator<Filter> getFilterIterator(Scan scan) {
        Filter topLevelFilter = scan.getFilter();
        Iterator<Filter> filterIterator = topLevelFilter == null ? Iterators.emptyIterator() : (topLevelFilter instanceof FilterList ? ((FilterList)topLevelFilter).getFilters().iterator() : Iterators.singletonIterator(topLevelFilter));
        return filterIterator;
    }

    public static boolean isRoundRobinPossible(OrderByCompiler.OrderBy orderBy, StatementContext context) throws SQLException {
        int fetchSize = context.getStatement().getFetchSize();
        return fetchSize > 1 && !ScanUtil.shouldRowsBeInRowKeyOrder(orderBy, context) && orderBy.getOrderByExpressions().isEmpty();
    }

    public static boolean forceRowKeyOrder(StatementContext context) {
        return context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.force.rowkeyorder", false);
    }

    public static boolean shouldRowsBeInRowKeyOrder(OrderByCompiler.OrderBy orderBy, StatementContext context) {
        return ScanUtil.forceRowKeyOrder(context) || orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY;
    }

    public static TimeRange intersectTimeRange(TimeRange rowTimestampColRange, TimeRange scanTimeRange, Long scn) throws IOException, SQLException {
        long scnToUse = scn == null ? Long.MAX_VALUE : scn;
        long lowerRangeToBe = 0L;
        long upperRangeToBe = scnToUse;
        if (rowTimestampColRange != null) {
            long minRowTimestamp = rowTimestampColRange.getMin();
            long maxRowTimestamp = rowTimestampColRange.getMax();
            if (lowerRangeToBe > maxRowTimestamp || upperRangeToBe < minRowTimestamp) {
                return null;
            }
            lowerRangeToBe = Math.max(lowerRangeToBe, minRowTimestamp);
            upperRangeToBe = Math.min(upperRangeToBe, maxRowTimestamp);
        }
        if (scanTimeRange != null) {
            long minScanTimeRange = scanTimeRange.getMin();
            long maxScanTimeRange = scanTimeRange.getMax();
            if (lowerRangeToBe > maxScanTimeRange || upperRangeToBe < lowerRangeToBe) {
                return null;
            }
            lowerRangeToBe = Math.max(lowerRangeToBe, minScanTimeRange);
            upperRangeToBe = Math.min(upperRangeToBe, maxScanTimeRange);
        }
        return new TimeRange(lowerRangeToBe, upperRangeToBe);
    }

    public static boolean isDefaultTimeRange(TimeRange range) {
        return range.getMin() == 0L && range.getMax() == Long.MAX_VALUE;
    }

    static {
        Arrays.fill(MAX_FILL_LENGTH_FOR_PREVIOUS_KEY, (byte)-1);
        ZERO_BYTE_ARRAY = new byte[1024];
    }
}

