/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Iterables;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.phoenix.util.SQLCloseable;

public class SQLCloseables {
    private SQLCloseables() {
    }

    public static void closeAll(Iterable<? extends SQLCloseable> iterable) throws SQLException {
        SQLException ex = SQLCloseables.closeAllQuietly(iterable);
        if (ex != null) {
            throw ex;
        }
    }

    public static SQLException closeAllQuietly(Iterable<? extends SQLCloseable> iterable) {
        if (iterable == null) {
            return null;
        }
        LinkedList<SQLException> exceptions = null;
        for (SQLCloseable sQLCloseable : iterable) {
            try {
                sQLCloseable.close();
            }
            catch (SQLException x) {
                if (exceptions == null) {
                    exceptions = new LinkedList<SQLException>();
                }
                exceptions.add(x);
            }
        }
        SQLException ex = MultipleCausesSQLException.fromSQLExceptions(exceptions);
        return ex;
    }

    private static class MultipleCausesSQLException
    extends SQLException {
        private static final long serialVersionUID = 1L;
        private final Collection<? extends SQLException> exceptions;
        private boolean hasSetStackTrace;

        static SQLException fromSQLExceptions(Collection<? extends SQLException> exceptions) {
            if (exceptions == null || exceptions.isEmpty()) {
                return null;
            }
            if (exceptions.size() == 1) {
                return Iterables.getOnlyElement(exceptions);
            }
            return new MultipleCausesSQLException(exceptions);
        }

        private MultipleCausesSQLException(Collection<? extends SQLException> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder(this.exceptions.size() * 50);
            int exceptionNum = 0;
            for (SQLException sQLException : this.exceptions) {
                sb.append("Cause Number " + exceptionNum + ": " + sQLException.getMessage() + "\n");
                ++exceptionNum;
            }
            return sb.toString();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (!this.hasSetStackTrace) {
                ArrayList<StackTraceElement> frames = new ArrayList<StackTraceElement>(this.exceptions.size() * 20);
                int exceptionNum = 0;
                for (SQLException sQLException : this.exceptions) {
                    StackTraceElement header = new StackTraceElement(MultipleCausesSQLException.class.getName(), "Exception Number " + exceptionNum, "<no file>", 0);
                    frames.add(header);
                    for (StackTraceElement ste : sQLException.getStackTrace()) {
                        frames.add(ste);
                    }
                    ++exceptionNum;
                }
                this.setStackTrace(frames.toArray(new StackTraceElement[frames.size()]));
                this.hasSetStackTrace = true;
            }
            return super.getStackTrace();
        }
    }
}

