/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Properties deepCopy(Properties properties) {
        Properties newProperties = new Properties();
        for (String pName : properties.stringPropertyNames()) {
            newProperties.setProperty(pName, properties.getProperty(pName));
        }
        return newProperties;
    }

    public static Properties extractProperties(Properties props, Configuration conf) {
        Iterator<Map.Entry<String, String>> iterator = conf.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                props.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return props;
    }
}

