/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.jdbc.PhoenixConnection;

abstract class ConfigurationAdapter {
    ConfigurationAdapter() {
    }

    public abstract String get(String var1, String var2);

    public static class HadoopConfigConfigurationAdapter
    extends ConfigurationAdapter {
        private Configuration conf;

        public HadoopConfigConfigurationAdapter(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public String get(String key, String defaultValue) {
            return this.conf.get(key, defaultValue);
        }
    }

    public static class ConnectionConfigurationAdapter
    extends ConfigurationAdapter {
        private PhoenixConnection conn;

        public ConnectionConfigurationAdapter(PhoenixConnection connection) {
            this.conn = connection;
        }

        @Override
        public String get(String key, String defaultValue) {
            return this.conn.getQueryServices().getProps().get(key, defaultValue);
        }
    }
}

