/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedFloatArray
extends PArrayDataType<float[]> {
    public static final PUnsignedFloatArray INSTANCE = new PUnsignedFloatArray();

    private PUnsignedFloatArray() {
        super("UNSIGNED_FLOAT ARRAY", 3000 + PUnsignedFloat.INSTANCE.getSqlType(), PhoenixArray.class, null, 46);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedFloat.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedFloat.INSTANCE, sortOrder, maxLength, scale, PUnsignedFloat.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        Object[] floatArr;
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        for (Object i : floatArr = (Object[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PUnsignedFloat.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getResultSetSqlType() {
        return 2003;
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
        this.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedFloat.INSTANCE, arrayLength, maxLength);
    }
}

