/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedDoubleArray
extends PArrayDataType<double[]> {
    public static final PUnsignedDoubleArray INSTANCE = new PUnsignedDoubleArray();

    private PUnsignedDoubleArray() {
        super("UNSIGNED_DOUBLE ARRAY", 3000 + PUnsignedDouble.INSTANCE.getSqlType(), PhoenixArray.class, null, 47);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedDouble.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedDouble.INSTANCE, sortOrder, maxLength, scale, PUnsignedDouble.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
        this.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        Object[] doubleArr;
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        for (Object i : doubleArr = (Object[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, i) || super.isCoercibleTo((PDataType)PUnsignedTimestamp.INSTANCE, i) || super.isCoercibleTo((PDataType)PUnsignedTime.INSTANCE, i) || super.isCoercibleTo((PDataType)PUnsignedDate.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getResultSetSqlType() {
        return 2003;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedDouble.INSTANCE, arrayLength, maxLength);
    }
}

