/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.text.Format;
import java.util.Date;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.DateUtil;

public class PUnsignedDate
extends PDataType<java.sql.Date> {
    public static final PUnsignedDate INSTANCE = new PUnsignedDate();

    private PUnsignedDate() {
        super("UNSIGNED_DATE", 19, java.sql.Date.class, new UnsignedDateCodec(), 14);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            throw PUnsignedDate.newIllegalDataException(this + " may not be null");
        }
        byte[] bytes = new byte[this.getByteSize().intValue()];
        this.toBytes(object, bytes, 0);
        return bytes;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PUnsignedDate.newIllegalDataException(this + " may not be null");
        }
        this.getCodec().encodeLong(((Date)object).getTime(), bytes, offset);
        return this.getByteSize();
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        java.sql.Date d = (java.sql.Date)PDate.INSTANCE.toObject(object, actualType);
        PUnsignedDate.throwIfNonNegativeDate(d);
        return d;
    }

    @Override
    public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        java.sql.Date d = (java.sql.Date)PDate.INSTANCE.toObject(b, o, l, actualType, sortOrder);
        PUnsignedDate.throwIfNonNegativeDate(d);
        return d;
    }

    @Override
    public boolean isCastableTo(PDataType targetType) {
        return PDate.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PUnsignedDate.equalsAny(targetType, this, PUnsignedTime.INSTANCE, PUnsignedTimestamp.INSTANCE) || PDate.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return super.isCoercibleTo(targetType, value) || PDate.INSTANCE.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return PDate.INSTANCE.getByteSize();
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PDate.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public Object toObject(String value) {
        return PDate.INSTANCE.toObject(value);
    }

    @Override
    public boolean isBytesComparableWith(PDataType otherType) {
        return super.isBytesComparableWith(otherType) || otherType.equals(PUnsignedTime.INSTANCE);
    }

    @Override
    public String toStringLiteral(Object o, Format formatter) {
        if (formatter == null || formatter == DateUtil.DEFAULT_DATE_FORMATTER) {
            formatter = DateUtil.DEFAULT_MS_DATE_FORMATTER;
        }
        return "'" + super.toStringLiteral(o, formatter) + "'";
    }

    @Override
    public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        if (ptr.getLength() > 0 && actualType == PUnsignedTimestamp.INSTANCE && actualModifier == expectedModifier) {
            ptr.set(ptr.get(), ptr.getOffset(), this.getByteSize());
            return;
        }
        super.coerceBytes(ptr, object, actualType, maxLength, scale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
    }

    @Override
    public int getResultSetSqlType() {
        return 91;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return new java.sql.Date((Long)PUnsignedLong.INSTANCE.getSampleValue(maxLength, arrayLength));
    }

    static class UnsignedDateCodec
    extends PUnsignedLong.UnsignedLongCodec {
        UnsignedDateCodec() {
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray(type, elements);
                }
            };
        }
    }
}

