/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PWholeNumber;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PSmallint
extends PWholeNumber<Short> {
    public static final PSmallint INSTANCE = new PSmallint();

    private PSmallint() {
        super("SMALLINT", 5, Short.class, new ShortCodec(), 4);
    }

    @Override
    public Integer getScale(Object o) {
        return ZERO;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return PLong.INSTANCE.compareTo(lhs, rhs, rhsType);
    }

    @Override
    public boolean isComparableTo(PDataType targetType) {
        return PDecimal.INSTANCE.isComparableTo(targetType);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 2;
    }

    @Override
    public Integer getMaxLength(Object o) {
        return SHORT_PRECISION;
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[2];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PSmallint.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeShort(((Number)object).shortValue(), bytes, offset);
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        Object o = PLong.INSTANCE.toObject(object, actualType);
        if (!(o instanceof Long) || o == null) {
            return o;
        }
        long l = (Long)o;
        if (l < -32768L || l > 32767L) {
            throw PSmallint.newIllegalDataException(actualType + " value " + l + " cannot be cast to Short without changing its value");
        }
        short s = (short)l;
        return s;
    }

    @Override
    public Short toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l == 0) {
            return null;
        }
        if (PSmallint.equalsAny(actualType, INSTANCE, PUnsignedSmallint.INSTANCE, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE, PInteger.INSTANCE, PUnsignedInt.INSTANCE, PFloat.INSTANCE, PUnsignedFloat.INSTANCE, PDouble.INSTANCE, PUnsignedDouble.INSTANCE)) {
            return actualType.getCodec().decodeShort(b, o, sortOrder);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return bd.shortValueExact();
        }
        PSmallint.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw PSmallint.newIllegalDataException(e);
        }
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            if (PSmallint.equalsAny(targetType, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE, PUnsignedLong.INSTANCE, PUnsignedInt.INSTANCE, PUnsignedSmallint.INSTANCE)) {
                short i = (Short)value;
                return i >= 0;
            }
            if (targetType == PUnsignedTinyint.INSTANCE) {
                short i = (Short)value;
                return i >= 0 && i <= 127;
            }
            if (targetType == PTinyint.INSTANCE) {
                short i = (Short)value;
                return i >= -128 && i <= 127;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.equals(targetType) || PInteger.INSTANCE.isCoercibleTo(targetType);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return ((Integer)PInteger.INSTANCE.getSampleValue(maxLength, arrayLength)).shortValue();
    }

    static class ShortCodec
    extends PDataType.BaseCodec {
        ShortCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            short v = this.decodeShort(b, o, sortOrder);
            if (v < -128 || v > 127) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            int v;
            Preconditions.checkNotNull(sortOrder);
            PDataType.checkForSufficientLength(b, o, 2);
            if (sortOrder == SortOrder.ASC) {
                v = b[o] ^ 0x80;
                for (int i = 1; i < 2; ++i) {
                    v = (v << 8) + (b[o + i] & 0xFF);
                }
            } else {
                v = b[o] ^ 0xFF ^ 0x80;
                for (int i = 1; i < 2; ++i) {
                    v = (v << 8) + ((b[o + i] ^ 0xFF) & 0xFF);
                }
            }
            return (short)v;
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 2);
            b[o + 0] = (byte)(v >> 8 ^ 0x80);
            b[o + 1] = (byte)v;
            return 2;
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < -32768L || v > 32767L) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeShort(v, b, o);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -32768.0 || v > 32767.0) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -32768.0f || v > 32767.0f) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveShortPhoenixArray(type, elements);
                }
            };
        }
    }
}

