/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TimeKeeper;

public class StatisticsWriter
implements Closeable {
    private final HTableInterface statsWriterTable;
    private final HTableInterface statsReaderTable;
    private final byte[] tableName;
    private final long clientTimeStamp;
    private final ImmutableBytesWritable minKeyPtr = new ImmutableBytesWritable();

    public static StatisticsWriter newWriter(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp) throws IOException {
        if (clientTimeStamp == Long.MAX_VALUE) {
            clientTimeStamp = TimeKeeper.SYSTEM.getCurrentTime();
        }
        HTableInterface statsWriterTable = env.getTable(TableName.valueOf(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES));
        HTableInterface statsReaderTable = ServerUtil.getHTableForCoprocessorScan(env, statsWriterTable);
        StatisticsWriter statsTable = new StatisticsWriter(statsReaderTable, statsWriterTable, tableName, clientTimeStamp);
        if (clientTimeStamp != -1L) {
            statsTable.commitLastStatsUpdatedTime();
        }
        return statsTable;
    }

    private StatisticsWriter(HTableInterface statsReaderTable, HTableInterface statsWriterTable, String tableName, long clientTimeStamp) {
        this.statsReaderTable = statsReaderTable;
        this.statsWriterTable = statsWriterTable;
        this.tableName = Bytes.toBytes(tableName);
        this.clientTimeStamp = clientTimeStamp;
    }

    @Override
    public void close() throws IOException {
        this.statsWriterTable.close();
    }

    public void splitStats(Region p, Region l, Region r, StatisticsCollector tracker, ImmutableBytesPtr cfKey, List<Mutation> mutations) throws IOException {
        boolean useMaxTimeStamp;
        if (tracker == null) {
            return;
        }
        boolean bl = useMaxTimeStamp = this.clientTimeStamp == -1L;
        if (!useMaxTimeStamp) {
            mutations.add(this.getLastStatsUpdatedTimePut(this.clientTimeStamp));
        }
        long readTimeStamp = useMaxTimeStamp ? Long.MAX_VALUE : this.clientTimeStamp;
        Result result = StatisticsUtil.readRegionStatistics(this.statsReaderTable, this.tableName, cfKey, p.getRegionInfo().getRegionName(), readTimeStamp);
        byte[] minKey = HConstants.EMPTY_BYTE_ARRAY;
        if (result != null && !result.isEmpty()) {
            Cell cell = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_BYTES);
            Cell rowCountCell = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES);
            Cell minKeyCell = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_KEY_BYTES);
            long rowCount = 0L;
            if (minKeyCell != null) {
                minKey = ByteUtil.copyKeyBytesIfNecessary(new ImmutableBytesWritable(minKeyCell.getValueArray(), minKeyCell.getValueOffset(), minKeyCell.getValueLength()));
            }
            if (cell != null) {
                int midEndIndex;
                int midStartIndex;
                long writeTimeStamp = useMaxTimeStamp ? cell.getTimestamp() : this.clientTimeStamp;
                GuidePostsInfo guidePostsRegionInfo = GuidePostsInfo.deserializeGuidePostsInfo(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), rowCount);
                byte[] pPrefix = StatisticsUtil.getRowKey(this.tableName, cfKey, p.getRegionInfo().getRegionName());
                mutations.add(new Delete(pPrefix, writeTimeStamp));
                long byteSize = 0L;
                Cell byteSizeCell = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES);
                int index = Collections.binarySearch(guidePostsRegionInfo.getGuidePosts(), r.getRegionInfo().getStartKey(), Bytes.BYTES_COMPARATOR);
                int size = guidePostsRegionInfo.getGuidePosts().size();
                if (index < 0) {
                    midEndIndex = midStartIndex = -(index + 1);
                } else {
                    midEndIndex = index;
                    midStartIndex = index + 1;
                }
                double per = (double)midEndIndex / (double)size;
                long leftRowCount = 0L;
                long rightRowCount = 0L;
                long leftByteCount = 0L;
                long rightByteCount = 0L;
                if (rowCountCell != null) {
                    rowCount = PLong.INSTANCE.getCodec().decodeLong(rowCountCell.getValueArray(), rowCountCell.getValueOffset(), SortOrder.getDefault());
                    leftRowCount = (long)(per * (double)rowCount);
                    rightRowCount = (long)((1.0 - per) * (double)rowCount);
                }
                if (byteSizeCell != null) {
                    byteSize = PLong.INSTANCE.getCodec().decodeLong(byteSizeCell.getValueArray(), byteSizeCell.getValueOffset(), SortOrder.getDefault());
                    leftByteCount = (long)(per * (double)byteSize);
                    rightByteCount = (long)((1.0 - per) * (double)byteSize);
                }
                if (midEndIndex > 0) {
                    GuidePostsInfo lguidePosts = new GuidePostsInfo(leftByteCount, guidePostsRegionInfo.getGuidePosts().subList(0, midEndIndex), leftRowCount);
                    tracker.clear();
                    tracker.addGuidePost(cfKey, lguidePosts, leftByteCount, cell.getTimestamp(), minKey);
                    this.addStats(l.getRegionInfo().getRegionName(), tracker, cfKey, mutations);
                }
                if (midStartIndex < size) {
                    GuidePostsInfo rguidePosts = new GuidePostsInfo(rightByteCount, guidePostsRegionInfo.getGuidePosts().subList(midStartIndex, size), rightRowCount);
                    tracker.clear();
                    tracker.addGuidePost(cfKey, rguidePosts, rightByteCount, cell.getTimestamp(), guidePostsRegionInfo.getGuidePosts().get(midStartIndex));
                    this.addStats(r.getRegionInfo().getRegionName(), tracker, cfKey, mutations);
                }
            }
        }
    }

    public void addStats(byte[] regionName, StatisticsCollector tracker, ImmutableBytesPtr cfKey, List<Mutation> mutations) throws IOException {
        if (tracker == null) {
            return;
        }
        boolean useMaxTimeStamp = this.clientTimeStamp == -1L;
        long timeStamp = this.clientTimeStamp;
        if (useMaxTimeStamp) {
            timeStamp = tracker.getMaxTimeStamp();
            mutations.add(this.getLastStatsUpdatedTimePut(timeStamp));
        }
        byte[] prefix = StatisticsUtil.getRowKey(this.tableName, cfKey, regionName);
        Put put = new Put(prefix);
        GuidePostsInfo gp = tracker.getGuidePosts(cfKey);
        if (gp != null) {
            put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_COUNT_BYTES, timeStamp, PLong.INSTANCE.toBytes(gp.getGuidePosts().size()));
            put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_BYTES, timeStamp, PVarbinary.INSTANCE.toBytes(gp.serializeGuidePostsInfo()));
            put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES, timeStamp, PLong.INSTANCE.toBytes(gp.getByteCount()));
            put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES, timeStamp, PLong.INSTANCE.toBytes(gp.getRowCount()));
            tracker.getMinKey(this.minKeyPtr);
            put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_KEY_BYTES, timeStamp, PVarbinary.INSTANCE.toBytes(ByteUtil.copyKeyBytesIfNecessary(this.minKeyPtr)));
        }
        put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timeStamp, ByteUtil.EMPTY_BYTE_ARRAY);
        mutations.add(put);
    }

    private static ClientProtos.MutationProto.MutationType getMutationType(Mutation m) throws IOException {
        if (m instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (m instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        throw new DoNotRetryIOException("Unsupported mutation type in stats commit" + m.getClass().getName());
    }

    public void commitStats(List<Mutation> mutations) throws IOException {
        if (mutations.size() > 0) {
            byte[] row = mutations.get(0).getRow();
            MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
            for (Mutation m : mutations) {
                mrmBuilder.addMutationRequest(ProtobufUtil.toMutation(StatisticsWriter.getMutationType(m), m));
            }
            MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
            CoprocessorRpcChannel channel = this.statsWriterTable.coprocessorService(row);
            MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub(channel);
            try {
                service.mutateRows(null, mrm);
            }
            catch (ServiceException ex) {
                ProtobufUtil.toIOException(ex);
            }
        }
    }

    private Put getLastStatsUpdatedTimePut(long timeStamp) {
        long currentTime = TimeKeeper.SYSTEM.getCurrentTime();
        byte[] prefix = this.tableName;
        Put put = new Put(prefix);
        put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.LAST_STATS_UPDATE_TIME_BYTES, timeStamp, PDate.INSTANCE.toBytes(new Date(currentTime)));
        return put;
    }

    private void commitLastStatsUpdatedTime() throws IOException {
        Put put = this.getLastStatsUpdatedTimePut(this.clientTimeStamp);
        this.statsWriterTable.put(put);
    }

    public void deleteStats(byte[] regionName, StatisticsCollector tracker, ImmutableBytesPtr fam, List<Mutation> mutations) throws IOException {
        long timeStamp = this.clientTimeStamp == -1L ? tracker.getMaxTimeStamp() : this.clientTimeStamp;
        byte[] prefix = StatisticsUtil.getRowKey(this.tableName, fam, regionName);
        mutations.add(new Delete(prefix, timeStamp - 1L));
    }
}

