/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsWriter;

public class StatisticsScanner
implements InternalScanner {
    private static final Log LOG = LogFactory.getLog(StatisticsScanner.class);
    private InternalScanner delegate;
    private StatisticsWriter stats;
    private Region region;
    private StatisticsCollector tracker;
    private ImmutableBytesPtr family;

    public StatisticsScanner(StatisticsCollector tracker, StatisticsWriter stats, Region region, InternalScanner delegate, ImmutableBytesPtr family) {
        this.tracker = tracker;
        this.stats = stats;
        this.delegate = delegate;
        this.region = region;
        this.family = family;
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        boolean ret = this.delegate.next(result);
        this.updateStat(result);
        return ret;
    }

    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        boolean ret = this.delegate.next(result, scannerContext);
        this.updateStat(result);
        return ret;
    }

    protected void updateStat(List<Cell> results) {
        if (!results.isEmpty()) {
            this.tracker.collectStatistics(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        IOException toThrow = null;
        try {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting the stats for the region " + this.region.getRegionInfo().getRegionNameAsString() + " as part of major compaction");
            }
            this.stats.deleteStats(this.region.getRegionInfo().getRegionName(), this.tracker, this.family, mutations);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding new stats for the region " + this.region.getRegionInfo().getRegionNameAsString() + " as part of major compaction");
            }
            this.stats.addStats(this.region.getRegionInfo().getRegionName(), this.tracker, this.family, mutations);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Committing new stats for the region " + this.region.getRegionInfo().getRegionNameAsString() + " as part of major compaction");
            }
            this.stats.commitStats(mutations);
            return;
        }
        catch (IOException e) {
            LOG.error("Failed to update statistics table!", e);
            toThrow = e;
        }
        finally {
            try {
                this.stats.close();
            }
            catch (IOException e) {
                if (toThrow == null) {
                    toThrow = e;
                }
                LOG.error("Error while closing the stats table", e);
            }
            finally {
                try {
                    this.delegate.close();
                }
                catch (IOException e) {
                    if (toThrow == null) {
                        toThrow = e;
                    }
                    LOG.error("Error while closing the scanner", e);
                }
                finally {
                    if (toThrow == null) return;
                    throw toThrow;
                }
            }
        }
    }
}

